<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_Log_Logger");
/**
 * Logger生成クラス
 *
 * 出力先名称と使用モジュール名から対応するLoggerを生成する。
 * @author okada
 *
 */
class CFW_Log_LoggerFactory{
    /**
     * Loggerを生成する
     * @param String $name ログ出力先の名前
     * @param String $module ログを使うモジュールの名前
     * @return CFW_Log_Logger 設定に基づくログ出力
     */
    public static function getLogger($name,$module){
        $config = CFW_Config_Configuration::getInstance("core");
        /* @var Zend_Config */
        $logConfig = $config->log->get($name);
        //writerを構築する
        $writerClassName = $logConfig->writer;
        Zend_Loader::loadClass($writerClassName);
        $writer = new $writerClassName();
        $writer->init($logConfig);
        //loggerを構築する
        $logger = new CFW_Log_Logger();
        $logger->logLevel = $logConfig->priority;
        $logger->moduleName = $module;
        $logger->writer = $writer;

        return $logger;
    }
    static function resolveName($name,$date){
        $n = str_replace("%Y",date("Y",$date),$name);
        $n = str_replace("%m",date("m",$date),$n);
        $n = str_replace("%d",date("d",$date),$n);

        return $n;
    }

}