<?php
Zend_Loader::loadClass("CFW_Data_Parameter");
Zend_Loader::loadClass("CFW_Data_Criteria");
Zend_Loader::loadClass("CFW_Data_Criteria_Condition");

/**
 * 列名と値を指定する条件式
 * @author michiakiokada
 *
 */
class CFW_Data_Criteria_ColumnValueCondition extends CFW_Data_Criteria_Condition{
    /**
    * @var string 列名
    */
    var $_name;
    /**
    * @var array　Paramterの配列
    */
    var $_parameters;
    /**
    * @var String 演算子
    */
    var $_operator;
    /**
    * @var String　Notなど
    */
    var $_modifier;
    
    /**
    * 列名と値を与えて構築する
    * @param string  $name
    * @param string $value
    * @param string $operator =,<>,etc...
    * @param string $modifier NOTなど
    */
    public function __construct($name,$value,$operator= CFW_Data_Criteria::OPERATOR_EQ,$modifier = CFW_Data_Criteria::OPERATOR_NONE)
    {
        parent::__construct();
        $this->_name = $name;
        $this->_parameters = array();
        $parameterName = "";
        $baseName = str_replace(".","_",$name);
        $parameter = null;
        if(is_array($value)){
            $n = 0;
            foreach($value as $v){
                $parameterName = ":P__". $baseName . "_" + n;
                $parameter = new CFW_Data_Parameter($parameterName,$v);
                $this->_parameters[] = $parameter;
            }
        }
        else{
            $parameterName = ":P__" . $baseName;
            $parameter = new CFW_Data_Parameter($parameterName,$value);
            $this->_parameters[] = $parameter;

        }
        $this->_operator = $operator;
        $this->_modifier = $modifier;
    }
    /* (non-PHPdoc)
     * @see CFW/Data/Criteria/CFW_Data_Criteria_Condition#buildExpression()
     */
    public function buildExpression(){
        $expression = "";
        if($this->_modifier != CFW_Data_Criteria::OPERATOR_NONE){
            $expression .= $this->_modifier . " ";
        }
        $expression .= $this->_name . " " . $this->_operator . " ";
        if(count($this->_parameters) == 1){
            $expression .= "?"; //$this->_parameters[0]->name; //...sqlsrvが名前付きパラメータをサポートしないので仕方が無く。

        }
        if(count($this->_parameters) > 1){
            $expression .= "(";
            $i = 0;
            if($this->_operator == CFW_Data_Criteria::OPERATOR_IN || $this->_operator == CFW_Data_Criteria::OPERATOR_NOT_IN){
                for($i = 0;i < $this->_parameters->length;$i++){
                    if($i > 0) $expression .= ",";
                    $expression .= "?" ; //$this->_parameters[i]->name;//...sqlsrvが名前付きパラメータをサポートしないので仕方が無く。
                }
            }
            else if($this->_operator == CFW_Data_Criteria::OPERATOR_BETWEEN){
                for($i = 0;i < $this->_parameters->length;$i++){
                    if(i > 0) $expression .= " AND ";
                    $expression .= "?"; //$this->_parameters[i]->name;//...sqlsrvが名前付きパラメータをサポートしないので仕方が無く。
                }
            }
            $expression .= ")";
        }


        return $expression;
    }
    /**
     * パラメータ
     */
    public function getParameters(){
        return $this->_parameters;
    }
        

}