<?php
Zend_Loader::loadClass("CFW_Data_Criteria");
class CFW_Data_Amf_CriteriaParser{
    /**
     * @var CFW_Data_Criteria
     */
    var $criteria;
    public function parse($c){
        $this->criteria = new CFW_Data_Criteria();
        $op  = "";
        foreach($c->where as $w){
            if(is_string($w)){
                $op = $w;
                continue;
            }
            Zend_Loader::loadClass($w->__amfClassName);

            if($w->__amfClassName == "CFW_Data_Criteria_ComplexCondition"){

                $this->criteria->addWhere($this->parseComplex($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_ColumnValueCondition"){
                $this->criteria->addWhere($this->parseColumnValue($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_StringValueCondition"){
                $this->criteria->addWhere($this->parseString($w),$op);
                continue;
            }
        }
        return $this->criteria;
    }

    function parseComplex($c){
        $complex = new CFW_Data_Criteria_ComplexCondition();
        $op = "";
        foreach($c->_conditions as $w){
            if(is_string($w)){
                $op = $w;
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_ComplexCondition"){
               $complex->add($this->parseComplex($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_ColumnValueCondition"){
                $complex->add($this->parseColumnValue($w),$op);
                continue;
            }
            if($w->__amfClassName == "CFW_Data_Criteria_StringValueCondition"){
                $complex->add($this->parseString($w),$op);
                continue;
            }
        }
        return $complex;
    }
    function parseColumnValue($c){
        $columnValue = new CFW_Data_Criteria_ColumnValueCondition(
            $c->_name,
            $c->_parameters[0]->value,
            $c->_operator,
            $c->_modifier
        );
        return $columnValue;
    }
    function parseString($c){
        $parameters = array();
        foreach($c->_parameters as $p){
            $parameters[] = new CFW_Data_Parameter($p->name,$p->value);
        }
        $string  = new CFW_Data_Criteria_StringCondition(
            $c->_expression,
            parameters
        );
        return $string;

    }
}