<?php
/**
 * tokenizer実験(2)
 * @author okada
 *
 */
class Tokenizer{
    const EOF = false;
    var $reader;
    /**
     * 最後に読み込んだ文字
     * @var unknown_type
     */
    var $c;
    
    
    
    public function __construct($str){
        $this->reader = new StringReader($str);
        $this->c = false;
    }
    public function hasMoreTokens(){
        return !$this->reader->isEOF();
    }
    public function nextToken(){
        if($this->reader->isEOF()){
            return self::EOF;
        }

        if(!$this->c){
            $c = $this->reader->read();
            if($this->reader->isEOF()){
                return self::EOF;
            }
        }
        
        /* white space読み飛ばし */
        if(($c == " ")||($c == "\t")||($c == "\r")||($c == "\n")){
            while(!$this->reader->isEOF()){
                $c = $this->reader->read();
                if(($c == " ")||($c == "\t")){
                    break;
                }
            }
            
        }
        
        $inquote = "";
        $token = "";
        while($c){
            //引用符
            if($c == "\""){
                if($inquote == ""){
                    $inquote= $c;
                    $token .= $c;
                    $c = $this->reader->read();
                    continue;
                }
                    
                if($c == $inquote){
                    //現在の文字が引用開始文字と同じところまで、引用符つき文字列
                    $token .= $c;
                    $inquote = "";
                    $c = $this->reader->read();
                    break;
                }
                //引用符付き文字列開始
                continue;
            }
            // 引用符の内側なら全部入れる
            if($inquote != ""){
                $token .= $c;
                $c = $this->reader->read();
                continue;
            }
            
            
            if(($c == "(") || ($c == ")") ){
                if($token == ""){
                    $token = $c;
                    break;
                }
                break;
            }    
            if($c == "\\"){
                $c2 = $this->reader->read();
                $token .= $c;
                $token .= $c2;
                
                continue;
            }
            if(($c == " ")||($c == "\t")||($c == "\r")||($c == "\n")){
                 break;
            }

            $token .= $c;
            $c = $this->reader->read();
            
        }   
        return $token;
        
        
    }
    
}

class StringReader{
    const EOF = false;
    var $str;
    var $len;
    var $ptr;
    
    var $pushBacked;
    
    public function __construct($s){
        $this->str = $s;
        $this->len = mb_strlen($s);
        $this->ptr = 0;
        $this->pushBacked = array();
        
    }
    public function read(){
        if($this->ptr >= $this->len  ){
            return self::EOF;
        }
        
        if(count($this->pushBacked) > 0){
            $c = array_pop($this->pushBacked);
        }
        else{
            $c = mb_substr($this->str,$this->ptr,1);
        }
        $this->ptr++;
        return $c;
    }
    public function pushBack($c){
        array_push( $this->pushBacked , $c );
        $this->ptr--;
        
    }
    public function isEOF(){
        if($this->ptr >= $this->len  ){
            return true;
        }
        return false;
        
    }
    
}


$s = "";
$tokenizer = null;
if(isset($_POST["text"])){
    $s =$_POST["text"]; 
    $tokenizer = new Tokenizer( $s );
    
}
else{
    
}



?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"> 
<title>tokenizer</title>
</head>
<body>
<div>
<form action="" method="post" >
<input type="text" name="text" id="text" value="<?php echo htmlspecialchars($s) ?>" size="100" /><br />
<input type="submit" name="submit" id="submit" value="send" />
</form>
<div id="result">
<?php if($tokenizer):?>
<?php while($tokenizer->hasMoreTokens()):?>
r=<?php echo htmlspecialchars($tokenizer->nextToken()) ?><br />
<?php endwhile;?>
<?php endif;?>
</div>
</div>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>