<?php
/**
 * ファイルシステム関数のショートカット
 * @author okada
 *
 */
class CFW_IO_FileSystem{
	/**
	 * ディレクトリ作成
	 * 
	 * $direSpecで指定したディレクトリ定義に基づき実ディレクトリを作成し、作成したディレクトリ名を返す
	 * @param $baseDir 基準ディレクトリ 必ず存在し、書き込めなければならない
	 * @param $dirSpec 追加ディレクトリの定義 配列
	 * @return String 作成したディレクトリ名
	 */
	public static function createDirectory($baseDir,$dirSpec = array()){
		
		$b = split(addslashes(DS),$baseDir);
		$path = "";
		foreach($b as $bb){
            $path = File_Util::buildPath(array($path,$bb));
            if(!file_exists($path)){
                mkdir($path);
            }
            
		}
		
		foreach($dirSpec as $dir){
			$path = File_Util::buildPath(array($path,$dir));
			if(!file_exists($path)){
				mkdir($path);
			}
		}
		return $path;
	}
}
?>