<?php
class CFW_Database_TableModel extends CFW_Model_AbstractModel{
    /**
     * データカタログ
     * @var unknown_type
     */
    var $_catalog;
    /**
     * データスキーマ名
     * @var unknown_type
     */
    var $_schema;
    /**
     * テーブル名
     * @var unknown_type
     */
    var $_name;
    /**
     * 主キー列
     * @var unknown_type
     */
    var $_primaryKeys = array();
    /**
     * 列
     * @var unknown_type
     */
    var $_columns;
    /**
     * データテーブルクラス
     * @var unknown_type
     */
    var $_dataTableType = "CFW_Model_DataTable";
    /**
     * 行クラス
     * @var unknown_type
     */
    var $_rowType = "CFW_Model_DataRow";
    
    var $datasource;
    
    /**
     * 構築
     * @return unknown_type
     */
    public function __construct(){
        $this->_columns = null;
    }
    /**
     * データソースに接続
     * @param $name
     * @return unknown_type
     */
    public function connect($name = "default"){
        
        $config = CFW_Common_Config::factory("datasource");
        $this->datasource = CFW_Model_DataSource::getDataSource($config->$name);
        $this->datasource->connect();
        
    }
    /**
     * 接続を閉じる
     * @return unknown_type
     */
    public function disconnect(){
        $this->datasource->disconnect();
        $this->datasource = null;
    }
    /**
     * このモデル定義での適切な新規行を生成
     * @return unknown_type
     */
    public function newRow(){
        $row = new $this->_rowType();
        $row->table = $this;
        return $row;
    }
    /**
     * このモデル定義での適切な新規データテーブル生成
     * @return unknown_type
     */
    public function newDataTable(){
        $datatable = new $this->_dataTableType();
        $datatable->_rowType = $this->_rowType;
        $datatable->table = $this;
        return $datatable;
    }
    
    
    /**
     * エンティティを保存
     * @param CFW_Model_Entity $entity
     * @return unknown_type
     */
    public function save(CFW_Model_Entity $entity){
        
        foreach($entity->rows as $row){
            $state = $row->rowState();
            if($state == CFW_Model_DataRow::STATE_NEW){
                $this->generateKeys($row);
               $this->datasource->insert($this,$row->_row);
                $this->setIdentity($row);
               
            }
            else if($state  == CFW_Model_DataRow::STATE_MODIFIED){
                $c = $this->_buildPrimaryKeyCriteria($row);
               $this->datasource->update($this,$row->_row,$c); 
            }
            else if($state  == CFW_Model_DataRow::STATE_DELETED){
                $c = $this->_buildPrimaryKeyCriteria($row);
                $this->datasource->delete($this,$c); 
            }
        }
    }
    /**
     * 主キーに一致する条件オブジェクトを生成
     * @param $row
     * @return unknown_type
     */
    function _buildPrimaryKeyCriteria($row){
        $c = new CFW_Database_Criteria();
        $i = 0;
        foreach($this->_primaryKeys as $key){
            if($i == 0){
                $c->add($key,$row->$key);
            }
            else{
                $c->addAnd($key,$row->$key);
                
            }
        }
        return $c;
    }
    /**
     * (non-PHPdoc)
     * @see Model/CFW_Model_AbstractModel#get()
     */
    public function get(CFW_Model_Criteria $criteria = null){
        return $this->datasource->read($this,$criteria); 
        
    }
    /**
     * (non-PHPdoc)
     * @see Model/CFW_Model_AbstractModel#remove()
     */
    public function remove(CFW_Model_Entity $entity){
        foreach($entity->rows as $row){
            $c = $this->_buildPrimaryKeyCriteria($row);
        }
        
    }
    /**
     * テーブルデータの追加
     * @param $values
     * @return unknown_type
     */
    public function insert($values){
        return $this->datasource->insert($this,$values);
        
    }
    /**
     * テーブルデータの更新
     * @param $values
     * @param $criteria
     * @return unknown_type
     */
    public function update($values,$criteria = null){
        return $this->datasource->update($this,$values,$criteria );
        
    }
    /**
     * テーブルデータの削除
     * @param $criteria
     * @return unknown_type
     */
    public function delete($criteria = null){
        return $this->datasource->delete($this,$criteria );
        
    }
    /**
     * identityやauto_incrementでない場合の主キー値生成
     * @param $row
     * @return unknown_type
     */
    public function generateKeys(&$row){
        
    }
    /**
     * identityやauto_increment列の再設定
     * @param $row
     * @return unknown_type
     */
    public function setIdentity(&$row){
        $col = $this->_columns[$this->_primaryKeys[0]];
        if($col->identity){
            $colName = $col->name;
            $row->$colName = $this->datasource->getLastId();
        }
        
    }
    
    
}
?>