<?php
/**
 * SQLデータベース用検索条件
 * @author okada
 *
 */
class CFW_Database_Criteria extends CFW_Model_Criteria{
	//recursive
	/**
	 * この条件に含まれるwhere条件オブジェクト
	 * @var array CFW_Data_Db_Criteria
	 */
	var $where;
	/**
	 * グルーピング
	 * @var unknown_type
	 */
	var $groupBy;
	/**
	 * ソート
	 * @var unknown_type
	 */
	var $orderBy;
	/**
	 * 集計抽出条件
	 * @var unknown_type
	 */
	var $having;
	
	/**
	 * この条件のwhere式
	 * @var unknown_type
	 */
	var $whereExpr;
	/**
	 * ソート式
	 * @var unknown_type
	 */
	var $orderByExpr;
	/**
	 * グルーピング式
	 * @var unknown_type
	 */
    var $groupByExpr;
    /**
     * 集計抽出条件式
     * @var unknown_type
     */
	var $havingExpr;
	/**
	 * 読み取りサイズ指定
	 * @var int
	 */
	var $limit;
	/**
	 * 読み取り開始位置(0から)指定
	 * @var int
	 */
	var $offset;
	
	/**
	 * $exprに対して設定されるパラメータ
	 * @var unknown_type
	 */
	var $params;
	
	/**
	 * 構築
	 * @return unknown_type
	 */
	public function __construct(){
        $this->where = array();
        $this->where = array();
        $this->orderBy = array();
        $this->having = array();
        $this->groupBy = array();
        $this->params = array();	
        $this->whereExpr = "";
        $this->orderByExpr = "";
        $this->groupByExpr = "";
        $this->havingExpr = "";
        $this->limit = 0;
        $this->offset = 0;
        
	}
	
    /**
     * 条件追加
     * 
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
	public function add($expr,$param = null,$op = "="){
        $this->where[] = array("expr" => $expr,"param" => $param,"cop" => "","op" => $op);
	}
    /**
     * 条件追加
     * 
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
	public function addAnd($expr,$param = null,$op = "="){
        $this->where[] = array("expr" => $expr,"param" => $param,"cop" => "AND","op" => $op);
    }
    /**
     * 条件追加
     * 
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
    public function addOr($expr,$param = null,$op = "="){
        $this->having[] = array("expr" => $expr,"param" => $param,"cop" => "OR","op" => $op);
    }

    /**
     * 集計抽出条件追加
     * @param $expr
     * @param $param
     * @param $op
     * @return unknown_type
     */
    public function addHaving($expr,$param = null,$op = "="){
        $this->having[] = array("expr" => $expr,"param" => $param,"cop" => "","op" => $op);
    }
    /**
     * 集計抽出条件追加
     * @param $expr
     * @param $param
     * @param $op
     * @return unknown_type
     */
    public function addHavingAnd($expr,$param = null,$op = "="){
        $this->having[] = array("expr" => $expr,"param" => $param,"cop" => "AND","op" => $op);
    }
    /**
     * 集計抽出条件追加
     * @param $expr
     * @param $param
     * @param $op
     * @return unknown_type
     */
    public function addHavingOr($expr,$param = null,$op = "="){
        $this->having[] = array("expr" => $expr,"param" => $param,"cop" => "OR","op" => $op);
    }
    
    /**
     * ソート列追加
     * @param $expr
     * @param $direction "ASC" or "DESC"
     * @return unknown_type
     */
    public function addOrderBy($expr,$direction = "ASC"){
        $this->orderBy[]= array( "expr" => $expr,"direction" => $direction);
    }
    /**
     * グルーピング列追加
     * @param $expr
     * @return unknown_type
     */
    public function addGroupBy($expr){
        $this->groupBy[]= $expr;
        
    }
    /**
     * 読み取りサイズ 設定
     * @param $limit
     * @return unknown_type
     */
    public function addLimit($limit){
        $this->limit = intval($limit);
    }
    /**
     * 読み取り開始位置設定
     * @param $offset
     * @return unknown_type
     */
    public function addOffset($offset){
        $this->offset = intval($offset);
    }
    
    /**
     * 条件を解析する
     * @return unknown_type
     */
	public function assemble(){
	    $this->assembleWhere();
        $this->assembleGroupBy();
        $this->assembleOrderBy();
        $this->assembleHaving();
        
	}
	/**
	 * where句の生成
	 * @return unknown_type
	 */
	function assembleWhere(){
        $str = "";      
    
        foreach($this->where as $c){
           if($c["expr"] instanceof CFW_Data_Criteria){
               $c["expr"]->assemble();
               $expr = $c["expr"]->getWhereExpression();
               $params = $c["expr"]->getParameters();
               $str .= " {$c["cop"]} ( {$expr} )";
               $this->params = array_merge($this->params,$params);
           }
           else{
               //式そのまま書く。 "( FIELD1 = :field1 )" など.is nullとか 
               if(substr($c["expr"],0,1) == "("){
                    $str .= " {$c["cop"]} {$c["expr"]} ";
                    if($c["param"] !== null){
                        $this->params = array_merge($this->params,$c["param"]);         
                    }
                    
               }
               else{
                    //exprは列名。
                    $op = strtoupper($c["op"]);
                    if($op == "IN" || $op == "NOT IN" ){
                        $i = 0;
                        $values = "";
                        foreach($c["param"] as $pp){
                            $p = ":" . $c["expr"] . $i;
                            if($i > 0) $values .= ", ";
                            $values .= $p;
                            $this->params[$p] = $pp;
                            $i++;
                        }
                        $expr = " {$c["cop"]} {$c["expr"]} {$op} ( {$values} )" ;
                        $str .=  $expr;
                        
                    }
                    else if($op == "BETWEEN"){
                        $i = 0;
                        $values = "";
                        foreach($c["param"] as $pp){
                            $p = ":" . $c["expr"] . $i;
                            if($i > 0) $values .= " AND  ";
                            $values .= $p;
                            $this->params[$p] = $pp;
                            $i++;
                        }
                        $expr = " {$c["cop"]} {$c["expr"]} {$op} ( {$values} )" ;
                        $str .=  $expr;
                        
                    }
                    else{
                        $p = ":" . $c["expr"];
                        
                        $expr = " {$c["cop"]} ({$c["expr"]} {$op} {$p} )" ;
                        $str .=  $expr;
                        $this->params[$p] = $c["param"];
                        
                    }
                             
               }
           }
        }
        $this->whereExpr =  $str;   
	    
	}
    /**
     * order by句の生成
     * @return unknown_type
     */
	function assembleOrderBy(){
        $str = "";
        foreach($this->orderBy as $orderBy){
            if($str !== "")$str .= ", ";
            $str .= $orderBy["expr"] . " " . $orderBy["direction"];
        }   
        $this->orderByExpr = $str;
    }
    /**
     * group by句の生成
     * @return unknown_type
     */
    function assembleGroupBy(){
        $str = "";
        foreach($this->groupBy as $groupBy){
            if($str !== "")$str .= ", ";
            $str .= $groupBy;
        }   
        $this->groupByExpr = $str;
        
    }
    /**
     * having句の生成
     * @return unknown_type
     */
    function assembleHaving(){
        $str = "";      
    
        foreach($this->having as $c){
           if($c["expr"] instanceof CFW_Data_Criteria){
               $c["expr"]->assemble();
               $expr = $c["expr"]->getHavingExpression();
               $params = $c["expr"]->getParameters();
               $str .= " {$c["cop"]} ( {$expr} )";
               $this->params = array_merge($this->params,$params);
           }
           else{
               //式そのまま書く。 "( FIELD1 = :field1 )" など.is nullとか 
               if(substr($c["expr"],0,1) == "("){
                    $str .= " {$c["cop"]} {$c["expr"]} ";
                    if($c["param"] !== null){
                        $this->params = array_merge($this->params,$c["param"]);         
                    }
                    
               }
               else{
                //exprは列名。
                    if($c["op"] == "IN" || $c["op"] == "NOT IN" ){
                        $i = 0;
                        $values = "";
                        foreach($c["param"] as $pp){
                            $p = ":" . $c["expr"] . $i;
                            if($i > 0) $values .= ", ";
                            $values .= $p;
                            $this->params[$p] = $pp;
                            $i++;
                        }
                        $expr = " {$c["cop"]} {$c["expr"]} {$c["op"]} ( {$values} )" ;
                        $str .=  $expr;
                        
                    }
                    else if($c["op"] == "BETWEEN"){
                        $i = 0;
                        $values = "";
                        foreach($c["param"] as $pp){
                            $p = ":" . $c["expr"] . $i;
                            if($i > 0) $values .= " AND  ";
                            $values .= $p;
                            $this->params[$p] = $pp;
                            $i++;
                        }
                        $expr = " {$c["cop"]} {$c["expr"]} {$c["op"]} ( {$values} )" ;
                        $str .=  $expr;
                        
                    }
                    else{
                        $p = ":" . $c["expr"];
                        
                        $expr = " {$c["cop"]} ({$c["expr"]} {$c["op"]} {$p} )" ;
                        $str .=  $expr;
                        $this->params[$p] = $c["param"];
                        
                    }
                             
               }
           }
        }
        $this->havingExpr =  $str;   
        
    }
    /**
	 * 条件解析後の式を取得
	 * @return unknown_type
	 */
	public function getWhereExpression(){
	    return $this->whereExpr;
	}
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
	public function getOrderByExpression(){
        return $this->orderByExpr;
	    
	}
    /**
     * 条件解析後の式を取得(逆ソート)
     * @return unknown_type
     */
	public function getOrderByReverseExpression(){
        $str = "";
        foreach($this->orderBy as $orderBy){
            if($str !== "")$str .= ", ";
            $dir = "DESC";
            if($orderBy["direction"] == "DESC"){
                $dir = "ASC";
            }
            $str .= $orderBy["expr"] . " " . $dir;
        }   
        return $str;
                
    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getGroupByExpression(){
        return $this->groupByExpr;
        
    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getHavingExpression(){
        return $this->havingExpr;
        
    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getLimit(){
        return $this->limit;
        
    }
    /**
     * 条件解析後の式を取得
     * @return unknown_type
     */
    public function getOffset(){
        return $this->offset;
        
    }
    /**
	 * この条件に設定されたパラメータを取得する
	 * @return unknown_type
	 */
	public function getParameters(){
        return $this->params;
	    
	}
	
}
?>