<?php
/**
 * Zend_Dbのショートカットクラス
 * 
 * 接続先単位にZend_Dbのインスタンスを作成する。
 * 設定はdatabase.iniに記述
 * @author okada
 *
 */
class CFW_Common_Database{
	/**
	 * 接続取得
	 * @param $name 接続先 指定しなければ"default"を使用する
	 * @param $env 実行環境
	 * @return Zen_Db
	 */
	public static function getConnection($name = "default",$env = ""){
		
		$dbconfig = CFW_Common_Config::factory("database",$env);
		$db = Zend_Db::factory($dbconfig->get($name));
		return $db;
	}
	public static function ArrayToIn($con,$arr,$type = null){
		$str = "";
		foreach($arr as $item){
			if($type === null ){
				$element = $con->quote($item);
			}
			else{
				$element = $con->quote($item,$type);
				
			}
			if($str != "") $str .= ", ";
			$str .= $element;
		}
		return $str;
		
	}
}
?>