<?php
/**
 * reader (1)
 * @author okada
 *
 */
class StringReader{
    const EOF = false;
    var $str;
    var $len;
    var $ptr;
    
    var $pushBacked;
    
    public function __construct($s){
        $this->str = $s;
        $this->len = mb_strlen($s);
        $this->ptr = 0;
        $this->pushBacked = array();
        
    }
    public function read(){
        if($this->ptr >= $this->len  ){
            return self::EOF;
        }
        
        if(count($this->pushBacked) > 0){
            $c = array_pop($this->pushBacked);
        }
        else{
            $c = mb_substr($this->str,$this->ptr,1);
        }
        $this->ptr++;
        return $c;
    }
    public function readLine(){
        if($this->ptr >= $this->len  ){
            return self::EOF;
        }
        $buffer = "";
        
        $pos = mb_strpos($this->str,"\r\n",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr);
            $this->ptr = $pos + 2;
            return $buffer;
        }
        $pos = mb_strpos($this->str,"\n",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr);
            $this->ptr = $pos + 1;
            return $buffer;
        }
        $pos = mb_strpos($this->str,"\r",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr);
            $this->ptr = $pos + 1;
            return $buffer;
        }
        $buffer = mb_substr($this->str,$this->ptr);
        $this->ptr = $this->len;
        return $buffer;
        
    }
    public function pushBack($c){
        array_push( $this->pushBacked , $c );
        $this->ptr--;
        
    }
    public function isEOF(){
        if($this->ptr >= $this->len  ){
            return true;
        }
        return false;
        
    }
    
}


$s = "";
$tokenizer = null;
$result = array();
if(isset($_POST["text"])){
    $s =$_POST["text"]; 
    $reader = new StringReader( $s );

    while(!$reader->isEOF()){
        $buffer = $reader->readLine();
        $result[] = $buffer;
    }
}
else{
    
}




?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"> 
<title>tokenizer</title>
<style type="text/css">
#text{
width : 50em;
height : 10em;
}
</style>
</head>
<body>
<div>
<form action="" method="post" >
<textarea id="text" name="text"><?php echo htmlspecialchars($s) ?></textarea><br />
<input type="submit" name="submit" id="submit" value="send" />
</form>
<div id="result">
<?php foreach($result as $row):?>
[<?php echo htmlspecialchars($row) ?>]<br />
<?php endforeach;?>
</div>
</div>
<script type="text/javascript">
//<![CDATA[
//]]>
</script>
</body>
</html>