<?php
/**
 * @author okada
 *
 */
class CFW_Util_String{

	const None = 0;
	const TrimLeft = 1;
	const TrimRight = 2;
	const TrimAll = 3;
	const DeleteSpace = 4;
	const DeleteWideSpace = 8;
	const DeleteTab = 16;
	const DeleteAllWhiteSpace = 31;
	const TabToSpace = 32;
	const ToNarrow = 64;
	const ToLower = 128;
	const ToUpper = 256;
	const ToAlpha = 512;
	const ToDigit = 1024;
	const ToAlphaDigit = 1536;
	const ToNumeric = 2048;
	const defaultMode = 35;
	/**
	 * 入力オブジェクトを文字列化
	 * @param object $o 入力オブジェクト
	 * @return string 入力オブジェクトを文字列化したもの
	 */
	public static function toString($o){
		$result = "";
		if ($o == null) {
			return $result;
		}
		else {
			if ($o instanceof Date) {
				$result = $o->format("%Y/%m/%d %H:%M:%S");
			}
			else {
				$result = "".$o;
				$result = self::deleteEscapeSequence($result);
			}
		}
		return $result;
	}
	/**
	 * 文字列の右側指定文字数分取得
	 * @param string $source 元の文字列
	 * @param string $length 長さ
	 * @return string 元の文字列の右側
	 */
	public static function right($source, $length){
		$sourceLength = mb_strlen($source);
		if ($sourceLength < $length) return $source;
		return mb_substr($source, ($sourceLength - $length), $length);
	}
	/**
	 * （余計だと思われる）エスケープシーケンスの削除
	 * 縦タブ、EOF文字、null文字を削除する。
	 * 特にnullインジェクションを回避するためにシステム外部の入力に対して必ず通す必要がある。
	 * @param string $s 対象文字列
	 * @return string 削除後の文字列
	 */
	public static function deleteEscapeSequence($s){
		$result = mb_ereg_replace("\v","",mb_ereg_replace("\x1a","",mb_ereg_replace("\x00","",$s)));
		return $result;
	}
	/**
	 * 改行削除
	 * @param string $s 元の文字列
	 * @return string $result 削除後の文字列
	 */
	public static function DeleteNewLine($s){
		$result = mb_ereg_replace("\r\n", "", $s);
		return $result;
	}
	/**
	 * tab -> 空白の削除
	 * @param string $s 元の文字列
	 * @return string 変換後の文字列
	 */
	public static function TabToWhiteSpace($s){
		$result = mb_ereg_replace("\t"," ",$s);
		return $result;
	}
	/**
	 * 空白削除
	 * 全角でも半角でもスペースっぽいものは取り除く、タブ文字も追加
	 * 文字列中の空白も対象
	 * @param string $s 元の文字列
	 * @return string $result 削除後の文字列
	 */
	public static function deleteAllWhiteSpace($s){
		$result = mb_ereg_replace("(　| |\t)+", "", $s);
		return $result;
	}
	/**
	 * trim()拡張
	 * 全角でも半角でもスペースっぽいものは取り除く、タブ文字も追加
	 * @param string $s 元の文字列
	 * @return string 削除後の文字列
	 */
	public static function trim($s){
		$result = mb_ereg_replace("^(　| |\t)+", "", $s);
		$result = mb_ereg_replace("(　| |\t)+$", "", $result);
		return $result;
	}
	/**
	 * trim()拡張
	 * 全角でも半角でもスペースっぽいものは取り除く、タブ文字も追加
	 * @param string $s 元の文字列
	 * @return string $result 削除後の文字列
	 */
	public static function trimLeft($s){
		$result = mb_ereg_replace("^(　| |\t)+","",$s);
			return $result;
	}
	/**
	 * trim()拡張
	 * 全角でも半角でもスペースっぽいものは取り除く、タブ文字も追加
	 * @param string $s 元の文字列
	 * @return string $result 削除後の文字列
	 */
	public static function trimRight($s){
		$result = mb_ereg_replace("(　| |\t)+$","",$s);
		return $result;
	}
	/**
	 * 全角カナ、全角英数を半角に変換
	 * @param string $s 対象文字列
	 * @return string $result 半角変換結果
	 */
	public static function toNarrow($s){
		$result = mb_convert_kana(mb_convert_kana($s, "a"), "k");
		$result = str_replace("￥", "\\", $result);
		return $result;
	}
	/**
	 * 半角カナ、半角英数を全角に変換
	 * @param string $s 対象文字列
	 * @return string $result 全角に変換した文字列
	 */
	public static function toWide($s){
		$result = mb_convert_kana(mb_convert_kana($s, "A"), "K");
		$result = str_replace("\\", "￥", $result);
		return $result;
	}
	/**
	 * 英数字を正規化する
	 * すべての空白、タブ文字、全角空白を取り除く
	 * @param string $s 元の文字列
	 * @return string $result 正規化結果
	 */
	public static function NormalizeAlphaNumeric($s){
		$object = self::deleteEscapeSequence($s);
		$result = mb_ereg_replace("[^0-9.\\-a-zA-Z]", "", $object);
		return $result;
	}
	/**
	 * 数字項目を正規化する
	 * すべての空白、タブ文字、全角空白を取り除く
	 * @param string $s 元の文字列
	 * @return string $result 正規化結果
	 */
	public static function NormalizeDigit($s){
		$object = self::deleteEscapeSequence($s);
		$result = mb_ereg_replace("[^0-9]", "", $object);
		return $result;
	}
	/**
	 * 英数字を正規化する
	 * すべての空白、タブ文字、全角空白を取り除く
	 * @param string $s 元の文字列
	 * @return strign $result 正規化結果
	 */
	public static function NormalizeAlpha($s){
		$object = self::deleteEscapeSequence($s);
		$result = mb_ereg_replace("[^a-zA-Z]","", $object);
		return $result;
	}
	/**
	 * 数字項目を正規化する
	 * すべての空白、タブ文字、全角空白を取り除く
	 * カンマを削除
	 * @param string $s 元の文字列
	 * @return string $result 正規化結果
	 */
	public static function NormalizeNumeric($s){
		$escape = self::deleteEscapeSequence($s);
		$narrow = self::toNarrow($escape);
		$line = self::DeleteNewLine($narrow);
		$space = self::deleteAllWhiteSpace($line);
		$result = mb_ereg_replace("[^0-9.\\-]", "", $space);
		return $result;
	}
	/**
	 * NormalizeString
	 * @param string $s 元の文字列
	 * @param integer $mode 正規化モード
	 * @return string $result 正規化された文字列
	 */
	public static function NormalizeString($s,$mode){
		$norm = self::deleteescapesequence($s);
		if (($mode & CFW_Util_String::TrimLeft) == CFW_Util_String::TrimLeft) {
			$norm = self::trimLeft($norm);
		}
		if (($mode & CFW_Util_String::TrimRight) == CFW_Util_String::TrimRight) {
			$norm = self::trimRight($norm);
		}
		if (($mode & CFW_Util_String::DeleteSpace) == CFW_Util_String::DeleteSpace) {
			$norm = mb_ereg_replace(" ", "", $norm);
		}
		if (($mode & CFW_Util_String::DeleteWideSpace) == CFW_Util_String::DeleteWideSpace) {
			$norm = mb_ereg_replace("　", "", $norm);
		}
		if (($mode & CFW_Util_String::DeleteTab) == CFW_Util_String::DeleteTab) {
			$norm = mb_ereg_replace("\t", "", $norm);
		}
		if (($mode & CFW_Util_String::ToNarrow) == CFW_Util_String::ToNarrow) {
			$norm = self::toNarrow($norm);
		}
		if (($mode & CFW_Util_String::ToLower) == CFW_Util_String::ToLower){
			$norm = mb_strtolower($norm);
		}
		if (($mode & CFW_Util_String::ToUpper) == CFW_Util_String::ToUpper) {
			$norm = mb_strtoupper($norm);
		}
		if (($mode & CFW_Util_String::ToAlphaDigit) == CFW_Util_String::ToAlphaDigit) {
			$norm = self::NormalizeAlphaNumeric($norm);
		}else{
			if (($mode & CFW_Util_String::ToDigit) == CFW_Util_String::ToDigit) {
				$norm = self::NormalizeDigit($norm);
			}
			if (($mode & CFW_Util_String::ToAlpha) == CFW_Util_String::ToAlpha) {
				$norm = self::NormalizeAlpha($norm);
			}
		}
		if (($mode & CFW_Util_String::ToNumeric) == CFW_Util_String::ToNumeric) {
			$norm = self::NormalizeNumeric($norm);
		}
		$result = $norm;
		return $result;
	}

	/**
	 * 特定文字列を繰り返した文字列を返す
	 * @param string $s 繰り返したい文字列
	 * @param int $times 回数
	 * @return string 文字列を指定回数繰り返した文字列
	 */
	public static function repeat($s, $times){
		$result = "";
		for($i = 0; $i < $times; $i++){
			$result .= $s;
		}
		return $result;
	}

	/**
	 * 文字列の正規化
	 * @param string $s
	 * @return string
	 */
	public static function normalize($s){
		//FIXME: NORMALIZE_MODEによって処理をわける
		return trim(self::deleteEscapeSequence($s));
	}
	public static function upperCamel($s){
	    $elements = preg_split ("[_\-]",$s);
	    $result = "";
	    foreach($elements as $element){
            $result .= ucfirst(strtolower($element));
	    }
	    return $result;
	}
    public static function lowerCamel($s){
        if(preg_match("#[_\-]#",$s) == 0){
            //区切り文字が無くて全部大文字の場合は小文字にして返す。
            if($s == strtoupper($s)) return strtolower($s);
            //全部が大文字じゃない場合、すでにcamelだと思ってそのまま返す
            return $s;
        }
        $elements = preg_split ("#[_\-]#",$s);
        $result = "";
        foreach($elements as $element){
            //lcfirstが5.3になるまで存在していない！から最初の要素だけ全て小文字にする事で対応
            if($result == "") $result .= strtolower($element);
            else $result .= ucfirst(strtolower($element));
        }
        return  $result;
    }
    /**
     * ランダム文字列生成(簡易)
     *
     * 適当にランダムな文字列を生成する。
     * ネタ元はhttp://tipstip.com/post/32/92/
     * @param integer $length
     * @return string
     */
    public static function randomString($length=8){
        $f='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $s='';
        $count = strlen($f)-1;
        for($i=0;$i<$length;$i++) $s.=substr($f,mt_rand(0,$count),1);
        return $s;
    }

    /**
     * キーと値の組み合わせを記述した文字列をキーと値に分割する
     * @param unknown_type $str
     * @param unknown_type $separator
     * @return multitype:unknown "key"と"value"を要素キーに持つ配列
     */
    public static function splitKeyValue($str,$separator = "="){
        $position = strpos($str,$separator);
        if($position === false){
            return array( "key" => self::trim($str),"value"=> "");
        }
        $key = self::trim( substr($str,0,$position - 1) );
        $value = self::trim( substr($str,$position + 1) );
        return array( "key" => $key,"value"=> $value);
    }
}