<?php
Zend_Loader::loadClass("CFW_Model_ITreeNode");

class CFW_Model_TreeNode implements CFW_Model_ITreeNode{
	var $parent;
	var $tree;
	var $children = array();
	var $name;
	var $object;

	public function __construct($name = ""){
		$this->name = $name;
	}
	public function getName(){
	    return $this->name;
	}
    public function setName($name){
        $this->name = $name;
    }
	public function getParent(){
	    return $this->parent;
	}
    public function setParent($parent){
        $this->parent = $parent;
    }
    function getChildren(){return $this->children;}
    function setChildren($children){$this->children = $children;}
    function getChild($name){return $this->children[$name];}

	public function appendChild(CFW_Model_ITreeNode $node){
		$this->children[$node->getName()] = $node;
		$node->setParent($this);
	}
	public function removeChilde(CFW_Model_ITreeNode $node){
		unset($this->children[$node->getName()]);
		$node->setParent(null);
	}
	/**
	 * このオブジェクトが指定ノードの先祖かどうか
	 * @param CFW_Model_ITreeNode $node
	 * @return unknown_type
	 */
	public function isAncestorOf(CFW_Model_ITreeNode $node){
		$result = false;
		$p = $node->getParent();
		while($p != null){
			if($this->getName()== $p->getName()){
				$result = true;
				break;
			}
			$p = $p->getParent();
		}
		return $result;
	}
	/**
	 * このオブジェクトが指定ノードの子孫かどうか
	 * @param CFW_Model_ITreeNode $node
	 * @return unknown_type
	 */
	public function isDescendantOf(CFW_Model_ITreeNode $node){
		return $node->isAncestorOf($this);
	}
	/* (non-PHPdoc)
	 * @see CFW/Model/CFW_Model_ITreeNode#pathString()
	 */
	public function pathString(){
		$path = $this->path();
		$result =join("/",$path);

		return $result;
	}

	/* (non-PHPdoc)
	 * @see CFW/Model/CFW_Model_ITreeNode#path()
	 */
	public function path(){
		$result = array($this->getName());

		$p = $this->getParent();
		while($p != null){
            if($p->getName() == "")break;
		    $result[] = $p->getName();
			$p = $p->getParent();
		}
		return array_reverse($result);
	}
	/* (non-PHPdoc)
	 * @see CFW/Model/CFW_Model_ITreeNode#find($path)
	 */
	public function find($path = array()){
		$target = null;
		$count = count($path);
		$current = $this;
		for($depth = 0;$depth < $count;$depth++){
			//現在のノードの子供に対象パスが見つかったらその子供を次のノードに設定する
			if(array_key_exists($path[$depth],$current->getChildren())){
				$current = $current->getChild($path[$depth]);
				//現在のノードを発見
				$target = $current;
				continue;
			}
			//見つからない
			break;
		}
		return $target;
	}
}