<?php
Zend_Loader::loadClass("Zend_Db");
Zend_Loader::loadClass("Zend_Db_Statement");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Model_Entity");
/**
 * データベース実行command
 * PDOを使うので、このオブジェクトが直接PDO_Statementを作成し実行する
 * @author okada
 *
 */
class CFW_Data_Command{
    /**
     * @var unknown_type
     */
    private $text;
    /**
     * @var unknown_type
     */
    private $parameters;

    /**
     * このコマンドを実行する先
     * @var CFW_Data_Connection
     */
    private $connection;
    /**
     * Zend_Db_Statement 実体
     * @var Zend_Db_Statement
     */
    private $statement;
    /**
     * @param unknown_type $text
     * @return unknown_type
     */
    public function __construct($text,$parameters = array()){
        $this->text = $text;
        $this->parameters = $parameters;
    }
    /**
     * 対象の接続を設定する
     * @param unknown_type $connection
     * @return unknown_type
     */
    public function setConnection(&$connection){
        $this->connection= $connection;
    }
    /**
     * パラメータコレクションを取得する。
     * @return unknown_type
     */
    public function getParameters(){
        return $this->parameters;
    }
    /**
     * パラメータを追加する
     * @param unknown_type $parameter
     * @return unknown_type
     */
    public function addParameter($parameter){
        $this->parameters[] = $parameter;
    }

    /**
     * 問い合わせを実行してデータの配列を返す。
     * @return Array 問い合わせ結果の配列(行、列)
     * @see PDOStatement#fetchAll
     */
    public function executeQuery(){
        $this->prepare();
        $this->statement->execute($this->parametersToArray());
        return $this->statement->fetchAll();
    }
    /**
     * 問い合わせを実行してデータリーダーを作る
     * @return CFW_Data_Reader 問い合わせ結果の配列(行、列)
     */
    public function executeReader(){
        $this->prepare();
        $this->statement->execute($this->parametersToArray());
        $reader = new CFW_Data_Reader();
        $reader->connection = $this->connection;
        $reader->statement = $this->statement;

        return $reader;
    }
    /**
     * 問い合わせを実行して指定クラス名のオブジェクトの配列を返す。
     * @return Array 問い合わせ結果の配列(行、列)
     * @see PDOStatement#fetchAll
     */
    public function executeQueryAsObject($className = "CFW_Model_Entity",$prefix = ""){
        $this->prepare();
        $this->statement->execute($this->parametersToArray());

        $result = array();
        while($row = $this->statement->fetch()){
            $object = new $className();
            $object->map($row,$prefix);
            $result[] = $object;
        }
        return $result;
    }
    /**
     * 更新処理を実行する。
     * @return unknown_type
     */
    public function executeUpdate(){
        $this->prepare();
        $result = $this->statement->execute($this->parametersToArray());
        //$count = $this->statement->rowCount();
        return $result;

    }
    /**
     * @return Zend_Db_Statement
     */
    private function prepare(){
        /* @var Zend_Db_Adapter_Abstract */
        $connection = &$this->connection->_connection;
        $this->statement = $connection->prepare($this->text);
        return $this->statement ;
    }
    /**
     * パラメータをステートメントオブジェクトにバインド
     * @return unknown_type
     */
    function bindParameters(){
        $paramOrdinal = 1;
        foreach($this->parameters as $param){
            $this->statement->bindParam($paramOrdinal,$param->value);
        }
    }
    function parametersToArray(){
        $parameters = array();
        foreach($this->parameters as $param){
            $parameters[] = $param->value;
        }
        return $parameters;

    }


}