<?php
abstract class CFW_Auth_Hash{
    /**
     *
     * @var CFW_Config_Configuration
     */
    var $config;
    /**
     * @param unknown_type $method
     * @return CFW_Auth_Hash
     */
    public static function getInstance($method = "PLAINTEXT"){
          if ($method == "MD5")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_Md5");
                return new CFW_Auth_Hash_Md5();
            }
            if ($method == "SHA1")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_Sha1");
                return new CFW_Auth_Hash_Sha1();
                            }
            if ($method == "SMD5")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_Smd5");
                return new CFW_Auth_Hash_Smd5();
                            }
            if ($method == "SSHA1")
            {
                Zend_Loader::loadClass("CFW_Auth_Hash_SSha1");
                return new CFW_Auth_Hash_SSha1();
            }

            Zend_Loader::loadClass("CFW_Auth_Hash_Default");
            return new CFW_Auth_Hash_Default();

    }
    /// <summary>
    /// 新しいハッシュを作る
    /// </summary>
    /// <param name="input"></param>
    /// <returns></returns>
    public abstract function createHash($input);
    /// <summary>
    /// 入力値のハッシュ結果が元の値になるか検証
    /// </summary>
    /// <param name="input"></param>
    /// <param name="target"></param>
    /// <returns></returns>
    public abstract function verify($input,$target);
    /// <summary>
    /// エンコードする
    /// </summary>
    /// <param name="bytes"></param>
    /// <returns></returns>
    public function encode($original)
    {

        $method = $this->config->encode;

        if ($method == "BASE64")
        {
            return base64_encode($original);
        }
        if ($method == "HEX")
        {
            return bin2hex ($original);
        }
        if ($method == "PLAIN")
        {
            return $original;

        }
        return "";
    }
    /// <summary>
    /// 入力文字のデコード
    /// </summary>
    /// <param name="s">入力文字</param>
    /// <returns>デコード結果のバイト配列</returns>
    public function decode($original)
    {
        $method  = $this->config->encode;
        if ($method == "BASE64")
        {
            return base64_decode($original);
        }
        if ($method == "HEX")
        {
            return hexdec($original);
        }
        if ($method == "PLAIN")
        {
            return $original;

        }
        return $original;
    }

}