<?php
// ldap バインドを使用する
$ldaprdn  = 'cn=Manager,dc=craft-net,dc=co,dc=jp';     // ldap rdn あるいは dn
$ldappass = 'secret';  // パスワード

// ldap サーバに接続する
$ldapconn = ldap_connect("192.168.0.229")
    or die("Could not connect to LDAP server.");

if ($ldapconn) {

    // ldap サーバにバインドする
    $ldapbind = ldap_bind($ldapconn, $ldaprdn, $ldappass);

    // バインド結果を検証する
    if ($ldapbind) {
        echo "LDAP bind successful...";
    } else {
        echo "LDAP bind failed...";
    }

    
    $sFilter = "(ou;lang-ja=システム*)"; 
    $iSerchID = ldap_search($ldapconn, 'ou=Users,dc=craft-net,dc=co,dc=jp', $sFilter);  
    echo "Search result is " . $iSerchID . "<br />"; 
    echo "Number of entires returned is " . ldap_count_entries($ldapconn, $iSerchID) . "<br />";

    //検索結果表示 
    echo "Getting entries ...<p>"; 
    $aList = ldap_get_entries($ldapconn, $iSerchID); 
    echo "Data for " . $aList["count"] . " items returned:<p>"; 
    for( $i=0; $i<$aList["count"]; $i++ ){ 
        echo "dn is: " . $aList[$i]["dn"] . "<br />"; 
        echo "first cn entry is: " . $aList[$i]["cn"][0] . "<br />"; 
        echo "first email entry is: " . $aList[$i]["mail"][0] . "<br />"; 
        echo "organization unit : " . $aList[$i]["ou"][0] . "<br />"; 
        echo "organization unit : " . $aList[$i]["ou"][1] . "<br />"; 
        //var_dump($aList[$i]); 
    }

    // クローズ 
    echo "Closing connection"; 
    ldap_close($ldapconn);    
}

?>