<?php
class CFW_Ldap_Criteria_Factor extends CFW_Ldap_Criteria_AbstractExpression{
    var $expr;
    
    public function parse(ArrayIterator &$iterator){
        $element = $iterator->current();
        if ($element instanceof CFW_Ldap_Criteria_ComplexElement) {
            
            $expr = new CFW_Ldap_Criteria_Expression();
            $it = new ArrayIterator(new ArrayObject($element->expr));
            $this->expr = $expr->parse($it);
            $this->expr->modifier = $element->modifier;
            $iterator->next();
            return $this;
        }
        else{
            $result = new CFW_Ldap_Criteria_RelativeCondition();
            $this->expr = $result->parse($iterator);
            $this->expr->modifier = $element->modifier;
            $iterator->next();
            return $this;
        }
    }
    public function getExpression(){
        return $this->expr->getExpression() ;
        
    }
    public function dump(){
        
        
        return $this->expr->dump() ;
    }
}

?>