<?php
class CFW_Ldap_Criteria extends CFW_Model_Criteria{
    /**
     * 検索開始ノード
     * @var unknown_type
     */
    var $baseDn; 
    var $expr;
    var $c;

    
    
    const CRITERIA_AND = "&";
    const CRITERIA_OR = "|";
    const CRITERIA_NOT = "!";
    const CRITERIA_EQ = "=";
    const CRITERIA_EQR = "~=";
    const CRITERIA_GE = ">=";
    const CRITERIA_LE = "<=";
    
    
    public function __construct(){
        $this->c = array();
        $this->expr = null;   
    }
    /**
     * 条件追加
     * 
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
    public function add($expr,$param = null,$op = "=",$modifier = ""){
        if($expr instanceof CFW_Ldap_Criteria){
            $this->c[] = new CFW_Ldap_Criteria_ComplexElement( $expr->c );
        }
        else{
            $el = new CFW_Ldap_Criteria_ExpressionElement($expr,$param,$op);
            $el->modifier = $modifier;
            $this->c[] = $el;
            
        }
        
    }
    /**
     * AND条件追加
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
    public function addAnd($expr,$param = null,$op = "=",$modifier = ""){
        if($expr instanceof CFW_Ldap_Criteria){
            $cop = new CFW_Ldap_Criteria_OperatorElement(self::CRITERIA_AND);
            $this->c[] = $cop;
            $this->c[] = new CFW_Ldap_Criteria_ComplexElement( $expr->c );
        }
        else{
            $cop = new CFW_Ldap_Criteria_OperatorElement(self::CRITERIA_AND);
            $this->c[] = $cop;
            
            $el = new CFW_Ldap_Criteria_ExpressionElement($expr,$param,$op);
            $el->modifier = $modifier;
            $this->c[] = $el;
            
        }
        
        
    }
    /**
     * OR条件追加
     * @param $expr 追加する条件式、列名、条件オブジェクトなど
     * @param $param $exprに設定するパラメータ
     * @param $op $exprが列名のとき $paramと比較するための演算子
     * @return unknown_type
     */
    public function addOr($expr,$param = null,$op = "=",$modifier = ""){
        if($expr instanceof CFW_Ldap_Criteria){
            $cop = new CFW_Ldap_Criteria_OperatorElement(self::CRITERIA_OR);
            $this->c[] = $cop;
            $this->c[] = new CFW_Ldap_Criteria_ComplexElement( $expr->c );
        }
        else{
            $cop = new CFW_Ldap_Criteria_OperatorElement(self::CRITERIA_OR);
            $this->c[] = $cop;
            
            $el = new CFW_Ldap_Criteria_ExpressionElement($expr,$param,$op);
            $el->modifier = $modifier;
            $this->c[] = $el;
            
        }
        
        
                
    }
    public function setBaseDn($baseDn){
        $this->baseDn = $baseDn;
    }
    public function getExpression(){
        if($this->expr === null){
            return "";
        }
        else{
            return $this->expr;
        }
        
    }
    function assemble(){
        $iterator = new ArrayIterator(new ArrayObject($this->c));
        
        $expr = new  CFW_Ldap_Criteria_Expression();
        $result = $expr->parse($iterator);
        
        $this->expr = $result->getExpression();        
        
    }
}
?>