<?php
/**
 * MS SqlServer用データソース
 * @author okada
 *
 */
class CFW_Database_DataSource_Mssql extends CFW_Database_AbstractDataSource{
    /**
     * (non-PHPdoc)
     * @see Database/CFW_Database_AbstractDataSource#getLastId()
     */
    public function getLastId(){
        $sql = 'SELECT SCOPE_IDENTITY() as id';
        $command = new CFW_Database_Command($sql);
        $command->setConnection($this->connection);

        $result = $command->executeQuery();
       
       
        $id = (int) $result->rows[0]->id;
        
        return $id;
    }
    /**
     * (non-PHPdoc)
     * @see Database/CFW_Database_AbstractDataSource#_buildFullName($model)
     */
    function _buildFullName(&$model){
        $fn = "";
        if( !empty($model->_catalog)) $fn .= $model->_catalog . "."; 
        if( !empty($model->_schema)) $fn .= $model->_schema. "."; 
        if( !empty($model->_name)) $fn .= $model->_name; 
        
        return $fn;
    }
    public function escapeWildCard($val){
        $str = $val;
        $str = mb_ereg_replace('\[','[[]',$str);
        $str = mb_ereg_replace('%','[%]',$str);
        $str = mb_ereg_replace('_','[_]',$str);
        return $str;
    }
    
        
}
?>