<?php
/**
 * メールアドレス表現クラス
 * 
 * @author okada
 *
 */
class CFW_Common_Mail_Address{
	/**
	 * アドレス
	 * @var String
	 */
	var $address;
	/**
	 * 
	 * @var String
	 */
	var $displayName;
	/**
	 * 
	 * @param $addr アドレス
	 * @param $disp 表示名
	 * @return unknown_type
	 */
	public function __construct($addr = null,$disp = null){
		$nameAndAddress = $this->SplitMailAddress($addr);
		if($disp == null){
			$this->address = $nameAndAddress["address"];	
			$this->displayName = $nameAndAddress["displayName"];	
		}
		else{
			$this->address = $nameAndAddress["address"];
			$this->displayName = $disp;	
			
		}
	}
	/**
	 * mailbox表現をaddr-specとdisplay-nameに分割
	 * @param $addressSpec mailbox表現( "hoge" <addr@example.com> など)
	 * @return Array "address"=addr-spec,"displayName"=display-name 
	 */
	function SplitMailAddress($addressSpec){
		$pos = 0;
		$pos =strrpos($addressSpec,"<");
		If($pos ===false){
			return array("address" => $addressSpec,"displayName" => "");
		}
		
		$addr = "";
		$disp = "";
		$disp = trim( substr($addressSpec,0,$pos - 1 ) );
		if(substr($disp,0,1) == "\"" ) {
			$disp = substr($disp,1);
		}
		if(substr($disp,-1) == "\"" ){
			$disp = substr($disp,0, -1);
		}
		$addr = trim( substr($addressSpec,$pos ));
		if(substr($addr,0,1) == "<" ) {
			$addr = substr($addr,1);
		}
		if(substr($addr,-1) == ">" ){
			$addr = substr($addr,0, -1);
		}
		
		return array("address" => $addr,"displayName" => $disp);
	
	}
	/**
	 * アドレスの検証
	 * @return unknown_type
	 */
	function isValid(){
		$validator = new 	Zend_Validate_EmailAddress();
		return $validator->isValid($this->address);
	}
	/**
	 * mailbox表現の文字列を返す
	 * @return String
	 */
	function __toString(){
		if($this->displayName == ""){
			return $this->address;
		}
		else{
			return "\"" . $this->displayName . "\" <" .$this->address . ">";
			
		}
	}
}
?>