using System;
using System.ComponentModel;
using System.Drawing;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.Web.UI.HtmlControls;
using System.Text;
using System.IO;

namespace Samples.AspNet.CS.Controls
{
    [
    AspNetHostingPermission(SecurityAction.InheritanceDemand,
    Level = AspNetHostingPermissionLevel.Minimal),
    AspNetHostingPermission(SecurityAction.Demand,
    Level = AspNetHostingPermissionLevel.Minimal),
    Designer(typeof(YuiModuleDesigner)),
    DefaultProperty("Title"),
    ToolboxData(
    "<{0}:YuiOverlay runat=\"server\"> </{0}:YuiOverlay>"),
    ]

    public class YuiOverlay : YuiModule
    {
        [
        Category("Display"),
        DefaultValue(true),
        Description("ConstraintViewport")
        ]
        public virtual bool ConstraintViewport
        {
            get
            {
                return (ViewState["ConstraintViewport"] == null ? false : (bool)ViewState["ConstraintViewport"]);
            }
            set
            {
                ViewState["ConstraintViewport"] = value;
            }

        }
        [
        Category("Display"),
        DefaultValue(""),
        Description("AlignContext")
        ]
        public virtual string AlignContext
        {
            get
            {
                string s = (string)ViewState["AlignContext"];
                return (s == null ? "":s);
            }
            set
            {
                ViewState["AlignContext"] = value;
            }
        }
        public enum Corner
        {
            TopLeft,
            TopRight,
            BottomRight,
            BottomLeft
        }
        [
        Category("Display"),
        DefaultValue(Corner.BottomLeft),
        Description("ContextCorner")
        ]
        public virtual Corner ContextCorner
        {
            get
            {
                return (ViewState["ContextCorner"] == null ? Corner.BottomLeft : (Corner)ViewState["ContextCorner"]);
            }
            set
            {
                ViewState["ContextCorner"] = value;
            }
        }
        [
        Category("Display"),
        DefaultValue(Corner.TopLeft),
        Description("OverlayCorner")
        ]
        public virtual Corner OverlayCorner
        {
            get
            {
                return (ViewState["OverlayCorner"] == null ? Corner.TopLeft : (Corner)ViewState["OverlayCorner"]);
            }
            set
            {
                ViewState["OverlayCorner"] = value;
            }
        }
        protected string CornerToConfig(Corner corner)
        {
            switch (corner)
            {
                case Corner.TopLeft: return "tl";
                case Corner.TopRight: return "tr";
                case Corner.BottomLeft: return "bl";
                case Corner.BottomRight: return "br";
                default: return "";
            }
        }
        [
        Category("Display"),
        DefaultValue(false),
        Description("FixedCenter")
        ]
        public virtual bool FixedCenter
        {
            get
            {
                return (ViewState["FixedCenter"] == null ? false : (bool)ViewState["FixedCenter"]);
            }
            set
            {
                ViewState["FixedCenter"] = value;
            }
        }
        public override string YuiClassName
        {
            get
            {
                return "YAHOO.widget.Overlay";
            }
        }
        
        protected override void BuildConfigurationElements(StringWriter writer)
        {
            base.BuildConfigurationElements(writer);

            if (this.AlignContext == "")
            {
            }
            else
            {
                string ctxTemplate = @",context : [ ""{0}"",""{1}"",""{2}"" ]";

                writer.Write(string.Format(ctxTemplate, this.AlignContext, CornerToConfig(this.OverlayCorner), CornerToConfig(this.ContextCorner)));
            }
            writer.Write(",fixedcenter:" + (this.FixedCenter ? "true" : "false"));
        }
    }
}
