using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Resources;
using System.Reflection;
namespace WindowsApplicationSample1
{
    public partial class ResourceCheckForm : Form
    {
        ResourceManager resourceManager;
        Assembly asm = Assembly.Load("Message.Resources");

        public ResourceCheckForm()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            if (resourceManager == null)
            {

                //\[X}l[W
                resourceManager = new ResourceManager(textBox1.Text, asm);
            }
            else
            {
                if (resourceManager.BaseName != textBox1.Text)
                {
                    resourceManager = new ResourceManager(textBox1.Text, asm);
                }
            }

            ResourceText.Text = resourceManager.GetString(textBox2.Text);

            sw.Stop();
            EllapsedTime.Text = "ellapsed " + sw.ElapsedMilliseconds.ToString() + " msec";
        }

        private void button2_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            AllKey.Text = "";
            if (resourceManager == null)
            {

                //\[X}l[W
                resourceManager = new ResourceManager(textBox1.Text, asm);
            }
            else
            {
                if (resourceManager.BaseName != textBox1.Text)
                {
                    resourceManager = new ResourceManager(textBox1.Text, asm);
                }
            }
            ResourceSet resourceSet = resourceManager.GetResourceSet(System.Globalization.CultureInfo.InvariantCulture, true, true);

            System.Collections.IDictionaryEnumerator id = resourceSet.GetEnumerator();
            while (id.MoveNext())
            {
                AllKey.Text  += id.Key.ToString() + " => " + id.Value.ToString() + Environment.NewLine;
            }
            sw.Stop();
            EllapsedTime.Text = "ellapsed " + sw.ElapsedMilliseconds.ToString() + " msec";

        }
    }
}