using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CFW.Util;
using CFW.FieldProperties;
using CFW.Forms;
using CFW.Forms.Filters;

namespace WindowsApplicationSample1.FormAdapterTest
{
    public partial class GcTextBoxAdapterTest : Form
    {

        TestProperty property;

        FormAdapterTest.StringEntity entity;
        FormAdapterTest.GcTextFormAdapter formAdapter;


        public GcTextBoxAdapterTest()
        {
            InitializeComponent();

            entity = new StringEntity();
            property = new TestProperty();
            formAdapter = new GcTextFormAdapter();

            property.Field1 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field1]", 50, 0, 0, false, "", false);
            property.Field2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 10, 0, 0, false, "", false);
            property.Field3 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field3]", 20, 0, 0, false, "", false);
            property.Field4 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field4]", 30, 0, 0, false, "", false);
            property.Field5 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field5]", 40, 0, 0, false, "", false);

            gcTextBox1.MaxLength = property.Field1.Length;
            gcTextBox2.MaxLength = property.Field2.Length;
            gcTextBox3.MaxLength = property.Field3.Length;
            gcTextBox4.MaxLength = property.Field4.Length;

            formAdapter.element1 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox1,
                new CFW.Forms.Filters.StringFilter(property.Field1, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToAlpha | StringUtil.NormalizeMode.ToUpper | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property.Field1)
            );
            formAdapter.element2 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox2,
                new CFW.Forms.Filters.StringFilter(property.Field2, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToAlpha | StringUtil.NormalizeMode.ToLower | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property.Field2)
            );
            formAdapter.element3 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox3,
                new CFW.Forms.Filters.StringFilter(property.Field3, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToDigit | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property.Field3)
            );
            formAdapter.element4 = new CFW.Windows.Forms.Adapters.GcTextBoxAdapterElement(
                this.gcTextBox4,
                new CFW.Forms.Filters.StringFilter(property.Field4, StringUtil.NormalizeMode.ToNarrow | StringUtil.NormalizeMode.ToAlphaDigit | StringUtil.NormalizeMode.ToUpper | StringUtil.NormalizeMode.TrimAll),
                CFW.Validators.FieldValidator.GetInstance(property.Field4)
            );

            formAdapter.SetEntity(this.entity);
            formAdapter.RenderView();

        }

        private void button1_Click(object sender, EventArgs e)
        {
            formAdapter.Bind();

            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.AppendLine(formAdapter.element1.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element2.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element3.ErrorMessage);
            messageBuilder.AppendLine(formAdapter.element4.ErrorMessage);


            this.validationMessage.Text = messageBuilder.ToString();
            if (formAdapter.IsValid)
            {
                StringEntity entity = (StringEntity)formAdapter.GetEntity();
                StringBuilder valuesBuilder = new StringBuilder();
                valuesBuilder.AppendLine("field1=" + entity.Field1);
                valuesBuilder.AppendLine("field2=" + entity.Field2);
                valuesBuilder.AppendLine("field3=" + entity.Field3);
                valuesBuilder.AppendLine("field4=" + entity.Field4);

                valuesText.Text = valuesBuilder.ToString();

            }


        }
    }
}