using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.Common;
using System.Drawing;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;

namespace WindowsApplicationSample1
{
    public partial class Form3 : Form
    {
        public Form3()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string contents = System.IO.File.ReadAllText(@"C:\temp\sample.config");
            Config.CustomConfiguration config = new Config.CustomConfiguration();
            config.load(contents);

            Config.CustomConfigurationSection da = config.GetSection("dataAccess");
            Config.CustomConfigurationElement el = da.GetCollection("add").GetElement("default");
            string className = el.GetAttribute("className");

            textBox2.Text = className;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();
                connection.Open();
                CFW.Database.Command command = new CFW.Database.Command("select * from MAST_MENU");
                DataSet result = connection.ExecuteQuery(command);

                System.IO.StreamWriter writer = new System.IO.StreamWriter("c:\\temp\\full.xml");
                XmlSerializer serializer = new XmlSerializer(result.GetType());
                serializer.Serialize(writer, result);

                writer.Close();
                sw.Stop();
                label1.Text = sw.ElapsedMilliseconds.ToString();



            }
            catch (Exception ex)
            {
                CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                throw;
            }
            finally
            {
                try
                {
                    connection.Close();
                }
                catch (Exception)
                {
                }
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();
                connection.Open();
                CFW.Database.Command command = new CFW.Database.Command("select * from MAST_MENU");
                DbDataReader result = connection.ExecuteReader(command);

                System.IO.StreamWriter writer = new System.IO.StreamWriter("c:\\temp\\Compact.xml");

                writer.Write("<table>");
                while (result.Read())
                {
                    writer.Write("<row>");
                    int colnum = result.FieldCount;
                    for (int c = 0; c < colnum; c++)
                    {
                        object o = result.GetValue(c);
                        if ((o == null) || (o == DBNull.Value)) continue;
                        writer.Write("<col name=\"" + result.GetName(c)  + "\"");
                        writer.Write(" value=\"" + o.ToString() + "\"");
                        writer.Write(" />");

                    }
                    writer.WriteLine("</row>");
                }
                writer.WriteLine("</table>");

                writer.Close();
                sw.Stop();
                label1.Text = sw.ElapsedMilliseconds.ToString();

            }
            catch (Exception ex)
            {
                CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                throw;
            }
            finally
            {
                try
                {
                    connection.Close();
                }
                catch (Exception)
                {
                }
            }

        }

        private void button4_Click(object sender, EventArgs e)
        {
            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();
                connection.Open();
                CFW.Database.Command command = new CFW.Database.Command("select * from MAST_MENU");
                DbDataReader result = connection.ExecuteReader(command);

                System.IO.StreamWriter writer = new System.IO.StreamWriter("c:\\temp\\Compact.json");

                writer.Write("[");
                int row = 0;
                while (result.Read())
                {
                    if (row > 0) writer.Write(",");
                    writer.Write("row:{");
                    int colnum = result.FieldCount;
                    for (int c = 0; c < colnum; c++)
                    {
                        if (c > 0) writer.Write(",");
                        object o = result.GetValue(c);
                        writer.Write("\"" + result.GetName(c) + "\":");
                        writer.Write(" \"" + CFW.Util.JavaScriptUtil.Escape(o.ToString()) + "\"");

                    }
                    writer.WriteLine("}");
                    row++;
                }
                writer.WriteLine("]");

                writer.Close();
                sw.Stop();
                label1.Text = sw.ElapsedMilliseconds.ToString();
            }
            catch (Exception ex)
            {
                CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();

                throw;
            }
            finally
            {
                try
                {
                    connection.Close();
                }
                catch (Exception)
                {
                }
            }
       }

    }
}