﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using CFW.Database;
using CFW.Database.TableCommand;
using CFW.FieldProperties;
public partial class test_MailAddressTest : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        int limit = CFW.Util.NumberUtil.Parse<int>(TextBox1.Text);
        int offset = CFW.Util.NumberUtil.Parse<int>(TextBox2.Text);

        Connection connection = ConnectionFactory.GetConnectionByName("default");
        connection.Open();


        PagedSelectCommand pageSelect = new PagedSelectCommand("MAST_SITE AS SITE INNER JOIN MAST_MENU AS MENU ON SITE.SITE_CODE = MENU.SITE_CODE");
        pageSelect.Offset = offset;
        pageSelect.Limit = limit;

        CFW.FieldProperties.FieldProperty site_site = FieldProperty.NewInstance("varchar", "SITE", "SITE_CODE", "[SITE_CODE]", 5, 0, 0, false, "", false);
        CFW.FieldProperties.FieldProperty site_name = FieldProperty.NewInstance("varchar", "SITE", "NAME", "[NAME]", 100, 0, 0, false, "", false);

        CFW.FieldProperties.FieldProperty site = FieldProperty.NewInstance("varchar", "MENU", "SITE_CODE", "[SITE_CODE]", 5, 0, 0, false, "", false);
        CFW.FieldProperties.FieldProperty menu = FieldProperty.NewInstance("varchar", "MENU", "MENU_CODE", "[MENU_CODE]", 4, 0, 0, false, "", false);
        CFW.FieldProperties.FieldProperty name = FieldProperty.NewInstance("varchar", "MENU", "NAME", "[NAME]", 100, 0, 0, false, "", false);

        pageSelect.AddSelect(site_site);
        pageSelect.AddSelect(site_name);
        pageSelect.AddSelect(site);
        pageSelect.AddSelect(menu);
        pageSelect.AddSelect(name);

        pageSelect.AddOrderBy(site, "ASC");
        pageSelect.AddOrderBy(menu, "ASC");

        Command command = pageSelect.GetCommand();
        Label1.Text = command.Text;

        DataSet result = connection.ExecuteQuery(command);

        foreach (DataRow row in result.Tables[0].Rows)
        {
            Literal literal = new Literal();
            literal.Text = CFW.Util.StringUtil.StringValue(row["MENU__SITE_CODE"]) + "," +
                CFW.Util.StringUtil.StringValue(row["MENU__MENU_CODE"]) + "," +
                CFW.Util.StringUtil.StringValue(row["SITE__NAME"]) + "," + 
                CFW.Util.StringUtil.StringValue(row["MENU__NAME"]) + "<br />"
                ;
            Panel1.Controls.Add(literal);
        }

        connection.Close();


    }
}
