using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Sample.Model;
using CFW.Sample.Model.Entity;
using CFW.Sample.Model.Property;
using CFW.Database.TableCommand;

namespace CFW.Sample.Model.Access
{
    /// <summary>
    /// MastMenu ANZX`
    /// </summary>
    [Serializable()]
	public class MastMenuAccess
	{
        Connection con;
        public MastMenuAccess()
        {
            con = ConnectionFactory.GetConnectionByName("default");
        }
        public List<MastMenuEntity> Get(string siteCode, string menuCode)
        {
            return new List<MastMenuEntity>();
        }
        public List<MastMenuEntity> Pagenate(int offset,int limit,string n)
        {
            try
            {
                con.Open();
                CFW.Database.TableAccess<MastMenuEntity, MastMenuProperty> access = new TableAccess<MastMenuEntity, MastMenuProperty>(con);
                List<TableCommandColumn> order = new List<TableCommandColumn>();
                order.Add(new TableCommandColumn("SITE_CODE", "MAST_MENU__SITE_CODE"));
                order.Add(new TableCommandColumn("MENU_CODE", "MAST_MENU__MENU_CODE"));
                MastMenuProperty p = new MastMenuProperty();
                ColumnValueCondition cond = new ColumnValueCondition(p.Name,"%" +  n  + "%","LIKE");

                List<MastMenuEntity> list = access.Pagenate(cond, order, offset, limit);
                con.Close();
                return list;

            }
            catch (Exception ex)
            {
                CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
                throw;
            }
        }
        public int Count(string n)
        {
            con.Open();
            CFW.Database.TableAccess<MastMenuEntity, MastMenuProperty> access = new TableAccess<MastMenuEntity, MastMenuProperty>(con);
                MastMenuProperty p = new MastMenuProperty();
                ColumnValueCondition cond = new ColumnValueCondition(p.Name,"%" +  n  + "%","LIKE");

            int count = access.Count(cond);
            con.Close();
            return count;
        }

	}

}