using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using SQLiteSample.Model;
using SQLiteSample.Model.TableRow;
using SQLiteSample.Model.TableProperty;

namespace SQLiteSample.Model.TableRow
{
    /// <summary>
    /// table postaldata Field`
    /// </summary>
    [Serializable()]
    public class PostaldataTableRow : AbstractTableRow,ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _Id;
        ///<summary>[id]</summary>
        public Int32 Id{
            get{return _Id;}
            set{_Id = value;}
        }
        ///<summary>[local_code]</summary>
        protected string _LocalCode;
        ///<summary>[local_code]</summary>
        public string LocalCode{
            get{return _LocalCode;}
            set{_LocalCode = value;}
        }
        ///<summary>[postal_code_5]</summary>
        protected string _PostalCode5;
        ///<summary>[postal_code_5]</summary>
        public string PostalCode5{
            get{return _PostalCode5;}
            set{_PostalCode5 = value;}
        }
        ///<summary>[postal_code]</summary>
        protected string _PostalCode;
        ///<summary>[postal_code]</summary>
        public string PostalCode{
            get{return _PostalCode;}
            set{_PostalCode = value;}
        }
        ///<summary>[prefecture_k]</summary>
        protected string _Prefecturek;
        ///<summary>[prefecture_k]</summary>
        public string Prefecturek{
            get{return _Prefecturek;}
            set{_Prefecturek = value;}
        }
        ///<summary>[city_k]</summary>
        protected string _Cityk;
        ///<summary>[city_k]</summary>
        public string Cityk{
            get{return _Cityk;}
            set{_Cityk = value;}
        }
        ///<summary>[area_k]</summary>
        protected string _Areak;
        ///<summary>[area_k]</summary>
        public string Areak{
            get{return _Areak;}
            set{_Areak = value;}
        }
        ///<summary>[prefecture]</summary>
        protected string _Prefecture;
        ///<summary>[prefecture]</summary>
        public string Prefecture{
            get{return _Prefecture;}
            set{_Prefecture = value;}
        }
        ///<summary>[city]</summary>
        protected string _City;
        ///<summary>[city]</summary>
        public string City{
            get{return _City;}
            set{_City = value;}
        }
        ///<summary>[area]</summary>
        protected string _Area;
        ///<summary>[area]</summary>
        public string Area{
            get{return _Area;}
            set{_Area = value;}
        }
        ///<summary>[flag1]</summary>
        protected Int32 _Flag1;
        ///<summary>[flag1]</summary>
        public Int32 Flag1{
            get{return _Flag1;}
            set{_Flag1 = value;}
        }
        ///<summary>[flag2]</summary>
        protected Int32 _Flag2;
        ///<summary>[flag2]</summary>
        public Int32 Flag2{
            get{return _Flag2;}
            set{_Flag2 = value;}
        }
        ///<summary>[flag3]</summary>
        protected Int32 _Flag3;
        ///<summary>[flag3]</summary>
        public Int32 Flag3{
            get{return _Flag3;}
            set{_Flag3 = value;}
        }
        ///<summary>[flag4]</summary>
        protected Int32 _Flag4;
        ///<summary>[flag4]</summary>
        public Int32 Flag4{
            get{return _Flag4;}
            set{_Flag4 = value;}
        }
        ///<summary>[flag5]</summary>
        protected Int32 _Flag5;
        ///<summary>[flag5]</summary>
        public Int32 Flag5{
            get{return _Flag5;}
            set{_Flag5 = value;}
        }
        ///<summary>[flag6]</summary>
        protected Int32 _Flag6;
        ///<summary>[flag6]</summary>
        public Int32 Flag6{
            get{return _Flag6;}
            set{_Flag6 = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public PostaldataTableRow() : base()
        {
            _Id = 0;
            _LocalCode = "";
            _PostalCode5 = "";
            _PostalCode = "";
            _Prefecturek = "";
            _Cityk = "";
            _Areak = "";
            _Prefecture = "";
            _City = "";
            _Area = "";
            _Flag1 = 0;
            _Flag2 = 0;
            _Flag3 = 0;
            _Flag4 = 0;
            _Flag5 = 0;
            _Flag6 = 0;
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void FromDataRow(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if(ColumnExists(row,columnName)) _Id = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "local_code");if(ColumnExists(row,columnName)) _LocalCode = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "postal_code_5");if(ColumnExists(row,columnName)) _PostalCode5 = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "postal_code");if(ColumnExists(row,columnName)) _PostalCode = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "prefecture_k");if(ColumnExists(row,columnName)) _Prefecturek = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "city_k");if(ColumnExists(row,columnName)) _Cityk = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "area_k");if(ColumnExists(row,columnName)) _Areak = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "prefecture");if(ColumnExists(row,columnName)) _Prefecture = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "city");if(ColumnExists(row,columnName)) _City = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "area");if(ColumnExists(row,columnName)) _Area = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "flag1");if(ColumnExists(row,columnName)) _Flag1 = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "flag2");if(ColumnExists(row,columnName)) _Flag2 = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "flag3");if(ColumnExists(row,columnName)) _Flag3 = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "flag4");if(ColumnExists(row,columnName)) _Flag4 = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "flag5");if(ColumnExists(row,columnName)) _Flag5 = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "flag6");if(ColumnExists(row,columnName)) _Flag6 = NumberUtil.Value<Int32>( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id") _Id = NumberUtil.Value<Int32>( value );
            if(name ==  "local_code") _LocalCode = StringUtil.StringValue( value );
            if(name ==  "postal_code_5") _PostalCode5 = StringUtil.StringValue( value );
            if(name ==  "postal_code") _PostalCode = StringUtil.StringValue( value );
            if(name ==  "prefecture_k") _Prefecturek = StringUtil.StringValue( value );
            if(name ==  "city_k") _Cityk = StringUtil.StringValue( value );
            if(name ==  "area_k") _Areak = StringUtil.StringValue( value );
            if(name ==  "prefecture") _Prefecture = StringUtil.StringValue( value );
            if(name ==  "city") _City = StringUtil.StringValue( value );
            if(name ==  "area") _Area = StringUtil.StringValue( value );
            if(name ==  "flag1") _Flag1 = NumberUtil.Value<Int32>( value );
            if(name ==  "flag2") _Flag2 = NumberUtil.Value<Int32>( value );
            if(name ==  "flag3") _Flag3 = NumberUtil.Value<Int32>( value );
            if(name ==  "flag4") _Flag4 = NumberUtil.Value<Int32>( value );
            if(name ==  "flag5") _Flag5 = NumberUtil.Value<Int32>( value );
            if(name ==  "flag6") _Flag6 = NumberUtil.Value<Int32>( value );
            
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            PostaldataTableRow clone = new PostaldataTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(PostaldataTableRow source)
        {
            this.Id = source.Id;
            this.LocalCode = source.LocalCode;
            this.PostalCode5 = source.PostalCode5;
            this.PostalCode = source.PostalCode;
            this.Prefecturek = source.Prefecturek;
            this.Cityk = source.Cityk;
            this.Areak = source.Areak;
            this.Prefecture = source.Prefecture;
            this.City = source.City;
            this.Area = source.Area;
            this.Flag1 = source.Flag1;
            this.Flag2 = source.Flag2;
            this.Flag3 = source.Flag3;
            this.Flag4 = source.Flag4;
            this.Flag5 = source.Flag5;
            this.Flag6 = source.Flag6;
            
        }
    }

}