using System;
using System.Collections.Generic;
using System.Text;
using CFW.Util;
using CFW.IO;
using CFW.Database;


namespace SQLiteSample
{
    /// <summary>
    /// f[^C|[g
    /// </summary>
    public class PostalDataImport
    {
        static CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.Name);

        /// <summary>
        /// ̓t@C
        /// </summary>
        public string inputFilename;
        /// <summary>
        /// ڑ
        /// </summary>
        public string connectionName;

        public int numImported = 0;

        CsvReader createReader()
        {
            FileSystem fs = FileSystemFactory.GetInstance();
            string buffer = fs.ReadText(this.inputFilename,System.IO.FileMode.Open,Encoding.GetEncoding("Shift_JIS"));
            CsvReader reader = new CsvReader(buffer,',');
            reader.FirstLineAsColumnDefinition = false;
            int c = 0;
            reader.ColumnDefinition.Add("local_code",c++);
            reader.ColumnDefinition.Add("postal_code_5",c++);
            reader.ColumnDefinition.Add("postal_code",c++);
            reader.ColumnDefinition.Add("prefecture_k",c++);
            reader.ColumnDefinition.Add("city_k",c++);
            reader.ColumnDefinition.Add("area_k", c++);
            reader.ColumnDefinition.Add("prefecture", c++);
            reader.ColumnDefinition.Add("city",c++);
            reader.ColumnDefinition.Add("area",c++);
            reader.ColumnDefinition.Add("flag1",c++);
            reader.ColumnDefinition.Add("flag2",c++);
            reader.ColumnDefinition.Add("flag3",c++);
            reader.ColumnDefinition.Add("flag4",c++);
            reader.ColumnDefinition.Add("flag5",c++);
            reader.ColumnDefinition.Add("flag6",c++);

            return reader;

        }
        CFW.Database.TableCommand.TableInsertCommand createInsertCommand()
        {
            CFW.Database.TableCommand.TableInsertCommand command = new CFW.Database.TableCommand.TableInsertCommand("postaldata");
            return command;

        }
            /// <summary>
        /// C|[g{
        /// </summary>
        public void Import()
        {
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "start");
            numImported = 0;
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "get connection");
            Connection connection = ConnectionFactory.GetConnectionByName(this.connectionName);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "get connection end");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "open connection");
            connection.Open();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "open connection end");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "begin tran");
            connection.BeginTransaction();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "begin tran end");

            Model.TableProperty.PostaldataTableProperty prop = new SQLiteSample.Model.TableProperty.PostaldataTableProperty();
            prop.Id.DoUpdate = false; //identity͑}񂩂珜O
            
            Model.TableAccess.PostaldataTableAccess da = new Model.TableAccess.PostaldataTableAccess(connection,prop);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "delete ");
            da.Delete((CFW.Database.TableCommand.TableCommandCondition)null);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "delete end");
            CsvReader reader = createReader();
            while (reader.Next())
            {
                Model.Entity.PostaldataEntity entity = new Model.Entity.PostaldataEntity();
                entity.LocalCode = reader.GetValue("local_code");
                entity.PostalCode5 = reader.GetValue("postal_code_5");
                entity.PostalCode = reader.GetValue("postal_code");
                entity.Prefecturek = reader.GetValue("prefecture_k");
                entity.Cityk = reader.GetValue("city_k");
                entity.Areak = reader.GetValue("area_k");
                entity.Prefecture = reader.GetValue("prefecture");
                entity.City = reader.GetValue("city");
                entity.Area = reader.GetValue("area");
                entity.Flag1 = NumberUtil.Value<int>( reader.GetValue("flag1") );
                entity.Flag2 = NumberUtil.Value<int>( reader.GetValue("flag2") );
                entity.Flag3 = NumberUtil.Value<int>( reader.GetValue("flag3") );
                entity.Flag4 = NumberUtil.Value<int>( reader.GetValue("flag4") );
                entity.Flag5 = NumberUtil.Value<int>( reader.GetValue("flag5") );
                entity.Flag6 = NumberUtil.Value<int>(reader.GetValue("flag6") );

                da.Insert(entity);
                numImported++;
            }
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "insert end");
            reader.Close();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "close reader");
            connection.CommitTransaction();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "commit tran");
            connection.Close();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "end");
        }
        /// <summary>
        /// C|[g{
        /// (command͐H)
        /// </summary>
        public void Import2()
        {
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "start");
            numImported = 0;
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "get connection start");
            Connection connection = ConnectionFactory.GetConnectionByName(this.connectionName);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "get connection end");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "open connection start");
            connection.Open();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "open connection end");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "begin transaction start");
            connection.BeginTransaction();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "begin transaction end");
            
            Model.TableProperty.PostaldataTableProperty prop = new SQLiteSample.Model.TableProperty.PostaldataTableProperty();
            prop.Id.DoUpdate = false; //identity͑}񂩂珜O

            Model.TableAccess.PostaldataTableAccess da = new Model.TableAccess.PostaldataTableAccess(connection,prop);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "delete");
            da.Delete((CFW.Database.TableCommand.TableCommandCondition)null);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "delete end");
            //̍scommand
            Command command = da.BuildInsertCommand(new SQLiteSample.Model.TableRow.PostaldataTableRow()).GetCommand();

            CsvReader reader = createReader();
            while (reader.Next())
            {
                Model.Entity.PostaldataEntity entity = new Model.Entity.PostaldataEntity();
                entity.LocalCode = reader.GetValue("local_code");
                entity.PostalCode5 = reader.GetValue("postal_code_5");
                entity.PostalCode = reader.GetValue("postal_code");
                entity.Prefecturek = reader.GetValue("prefecture_k");
                entity.Cityk = reader.GetValue("city_k");
                entity.Areak = reader.GetValue("area_k");
                entity.Prefecture = reader.GetValue("prefecture");
                entity.City = reader.GetValue("city");
                entity.Area = reader.GetValue("area");
                entity.Flag1 = NumberUtil.Value<int>(reader.GetValue("flag1"));
                entity.Flag2 = NumberUtil.Value<int>(reader.GetValue("flag2"));
                entity.Flag3 = NumberUtil.Value<int>(reader.GetValue("flag3"));
                entity.Flag4 = NumberUtil.Value<int>(reader.GetValue("flag4"));
                entity.Flag5 = NumberUtil.Value<int>(reader.GetValue("flag5"));
                entity.Flag6 = NumberUtil.Value<int>(reader.GetValue("flag6"));

                command.SetParameter(new Parameter(prop.LocalCode, entity.LocalCode));
                command.SetParameter(new Parameter(prop.PostalCode5, entity.PostalCode5));
                command.SetParameter(new Parameter(prop.PostalCode, entity.PostalCode));
                command.SetParameter(new Parameter(prop.Prefecturek, entity.Prefecturek));
                command.SetParameter(new Parameter(prop.Cityk, entity.Cityk));
                command.SetParameter(new Parameter(prop.Areak, entity.Areak));
                command.SetParameter(new Parameter(prop.Prefecture, entity.Prefecture));
                command.SetParameter(new Parameter(prop.City, entity.City));
                command.SetParameter(new Parameter(prop.Area, entity.Area));
                command.SetParameter(new Parameter(prop.Flag1, entity.Flag1));
                command.SetParameter(new Parameter(prop.Flag2, entity.Flag2));
                command.SetParameter(new Parameter(prop.Flag3, entity.Flag3));
                command.SetParameter(new Parameter(prop.Flag4, entity.Flag4));
                command.SetParameter(new Parameter(prop.Flag5, entity.Flag5));
                command.SetParameter(new Parameter(prop.Flag6, entity.Flag6));

                connection.ExecuteUpdate(command);
                numImported++;
            }
            reader.Close();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "reader close");
            connection.CommitTransaction();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "commit transaction done");
            connection.Close();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "end");
        }

        /// <summary>
        /// C|[g{
        /// </summary>
        public void Import3()
        {
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "start");
            numImported = 0;
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "get connection");
            Connection connection = ConnectionFactory.GetConnectionByName(this.connectionName);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "get connection end");

            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "open connection");
            connection.Open();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "open connection end");

            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "begin tran");
            connection.BeginTransaction();
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "begin tran end");


            Model.TableProperty.PostaldataTableProperty prop = new SQLiteSample.Model.TableProperty.PostaldataTableProperty();
            prop.Id.DoUpdate = false; //identity͑}񂩂珜O

            Model.TableAccess.PostaldataTableAccess da = new Model.TableAccess.PostaldataTableAccess(connection, prop);

            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "delete ");
            da.Delete((CFW.Database.TableCommand.TableCommandCondition)null);
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "delete end");

        }
    }
}
