using System;
using System.Collections.Generic;
using System.Text;

namespace Crypt
{
    class Program
    {
        static CryptProcess process;
        static void Main(string[] args)
        {
            if (args.Length == 0)
            {
                usage();
                System.Environment.Exit(-1);
            }
            CFW.Util.CommandLineArgs commandLineArgs = new CFW.Util.CommandLineArgs();
            commandLineArgs.Parse();
            if (commandLineArgs.GetUnnamedCount() == 0)
            {
                if (commandLineArgs.GetNamed("/input") == "")
                {
                    usage();
                    System.Environment.Exit(-1);
                }
            }
            if (commandLineArgs.GetNamed("/private") == "")
            {
                usage();
                System.Environment.Exit(-1);
            }
            if (commandLineArgs.GetNamed("/public") == "")
            {
                usage();
                System.Environment.Exit(-1);
            }
            process = new CryptProcess();
            if (commandLineArgs.GetUnnamedCount() > 0)
            {
                process.OriginalString = commandLineArgs.GetUnnamed(0);
            }
            else
            {
                if (commandLineArgs.GetNamed("/input") != "")
                {
                    string encodingString = commandLineArgs.GetNamed("/encoding");
                    Encoding encoding = null;
                    if (encodingString == "") encoding = Encoding.Default;
                    else encoding = Encoding.GetEncoding(encodingString);
                    process.OriginalString = System.IO.File.ReadAllText( commandLineArgs.GetNamed("/input") ,encoding);
                }
            }
            process.PrivateKey = commandLineArgs.GetNamed("/private");
            process.PublicKey = commandLineArgs.GetNamed("/public");

            process.Start();

        }

        static void usage()
        {
            System.Console.Out.WriteLine("Crypt.exe /private:(privateKey) /public:(publickey) (original string)");
            System.Console.Out.WriteLine("or ");
            System.Console.Out.WriteLine("Crypt.exe /private:(privateKey) /public:(publickey) /input:(input file) [/encoding:(encoding)]");
            System.Console.Out.WriteLine("Íʂ͕Wo͂ɏo͂܂B");
            System.Console.Out.WriteLine("t@Cɕۑꍇ \">\"gă_CNgĂB");

        }
    }
}
