using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.Database;
using CFW.FieldProperties;
using CFW.Model;

namespace CFWDatabaseTest.tableProperty
{
    [TestFixture]
    class DefaultTablePropertyTest
    {
        CFW.Database.Config.ConnectionConfigElement config;
        CFW.Database.Connection con;


        [NUnit.Framework.SetUp]
        public void init()
        {
            config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            con = CFW.Database.ConnectionFactory.GetConnection(config);
        }


        [Test]
        public void DescribeTest()
        {
            IEntityProperty property = con.DescribeTable("users") ;
            Assert.IsInstanceOfType(typeof(DefaultTableProperty), property);

            DefaultTableProperty tableProperty = property as DefaultTableProperty;
            Assert.AreEqual("users", tableProperty.TableName);

            IEnumerator<FieldProperty> fieldEnumerator = tableProperty.GetFields();
            fieldEnumerator.MoveNext();
            Assert.AreEqual("user_id", fieldEnumerator.Current.FieldName);
            fieldEnumerator.MoveNext();
            Assert.AreEqual("password", fieldEnumerator.Current.FieldName);
            fieldEnumerator.MoveNext();
            Assert.AreEqual("user_name", fieldEnumerator.Current.FieldName);
            fieldEnumerator.MoveNext();
            Assert.AreEqual("num_fields", fieldEnumerator.Current.FieldName);
            fieldEnumerator.MoveNext();
            Assert.AreEqual("birthday", fieldEnumerator.Current.FieldName);
            fieldEnumerator.MoveNext();
            Assert.AreEqual("create_at", fieldEnumerator.Current.FieldName);
            fieldEnumerator.MoveNext();
            Assert.AreEqual("modified_at", fieldEnumerator.Current.FieldName);



        }
    }
}
