using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFWDatabaseTest
{
    [TestFixture]
    public class TableRowTest
    {
        [NUnit.Framework.Test]
        public void RowStatus()
        {
            TestTableRow row = new TestTableRow();
            Assert.IsTrue(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsFalse(row.IsDeleted);


            row.IsModified = true;
            Assert.IsTrue(row.IsNew);
            Assert.IsTrue(row.IsModified);
            Assert.IsFalse(row.IsDeleted);

            row.IsDeleted = true;
            Assert.IsTrue(row.IsNew);
            Assert.IsTrue(row.IsModified);
            Assert.IsTrue(row.IsDeleted);

            row.IsDeleted = false;
            Assert.IsTrue(row.IsNew);
            Assert.IsTrue(row.IsModified);
            Assert.IsFalse(row.IsDeleted);


            row.IsModified = false;
            Assert.IsTrue(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsFalse(row.IsDeleted);

            row.IsDeleted = true;
            Assert.IsTrue(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsTrue(row.IsDeleted);

            row.IsDeleted = false;
            Assert.IsTrue(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsFalse(row.IsDeleted);
            
            
            
            row.IsNew = false;
            Assert.IsFalse(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsFalse(row.IsDeleted);

            row.IsModified = true;
            Assert.IsFalse(row.IsNew);
            Assert.IsTrue(row.IsModified);
            Assert.IsFalse(row.IsDeleted);

            row.IsDeleted = true;
            Assert.IsFalse(row.IsNew);
            Assert.IsTrue(row.IsModified);
            Assert.IsTrue(row.IsDeleted);

            row.IsDeleted = false;
            Assert.IsFalse(row.IsNew);
            Assert.IsTrue(row.IsModified);
            Assert.IsFalse(row.IsDeleted);


            row.IsModified = false;
            Assert.IsFalse(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsFalse(row.IsDeleted);

            row.IsDeleted = true;
            Assert.IsFalse(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsTrue(row.IsDeleted);

            row.IsDeleted = false;
            Assert.IsFalse(row.IsNew);
            Assert.IsFalse(row.IsModified);
            Assert.IsFalse(row.IsDeleted);



        }
    }
}
