using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;

namespace CFWDatabaseTest.TableCommand
{
    [TestFixture]
    public class TableCommandConditinTest
    {
        FieldProperty field1;
        FieldProperty field2;
        FieldProperty field3;
        FieldProperty field4;
        FieldProperty field5;
        FieldProperty field6Sub1;
        FieldProperty field6Sub2;

        CFW.Database.Config.ConnectionConfigElement config;
        CFW.Database.Connection con;

        [NUnit.Framework.SetUp]
        public void init()
        {
            field1 = FieldProperty.NewInstance("int", "test_table3", "field1", "[field1]", 4, 10, 0, false, 0, true);
            field2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 50, 0, 0, false, "", false);
            field3 = FieldProperty.NewInstance("datetime", "test_table3", "field3", "[field3]", 16, 23, 3, true, null, false);
            field4 = FieldProperty.NewInstance("decimal", "test_table3", "field4", "[field4]", 12, 10, 2, true, null, false);
            field5 = FieldProperty.NewInstance("smallint", "test_table3", "field5", "[field5]", 2, 5, 0, true, null, false);
            field6Sub1 = FieldProperty.NewInstance("int", "test_table3", "field6_sub1", "[field6_sub1]", 4, 10, 0, true, null, false);
            field6Sub2 = FieldProperty.NewInstance("int", "test_table3", "field6_sub2", "[field6_sub2]", 4, 10, 0, true, null, false);

            config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            con = CFW.Database.ConnectionFactory.GetConnection(config);
        }

        [NUnit.Framework.TearDown]
        public void term()
        {
        }
        [Test]
        public void ComplexConditionTest()
        {

            ComplexCondition condition = new ComplexCondition();
            condition.AddCondition(new ColumnValueCondition(field1, 1, ">="));
            condition.AddCondition("AND" ,new ColumnValueCondition(field1, 10, "<="));
            condition.AddCondition("OR", new ColumnValueCondition(field1, 100, "<="));
            condition.AddCondition("OR", new ColumnValueCondition(field2, "101010101", "="));
            condition.AddCondition("OR", new ColumnValueCondition(field2, new string[] { "10","20" }, "IN"));

            ComplexCondition cond2 = new ComplexCondition();
            cond2.AddCondition(new ColumnValueCondition(field1, 1, ">="));
            cond2.AddCondition("AND", new ColumnValueCondition(field1, 10, "<="));
            cond2.AddCondition("OR", new ColumnValueCondition(field1, 100, "<="));
            cond2.AddCondition("OR", new ColumnValueCondition(field2, "101010101", "="));
            cond2.AddCondition("OR", new ColumnValueCondition(field2, new string[] { "10", "20" }, "IN"));

            condition.AddCondition("AND", cond2);

            string expression = condition.BuildCondition();
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual(" ( test_table3.field1 >= @test_table3__field1 ) AND ( test_table3.field1 <= @test_table3__field1 ) OR ( test_table3.field1 <= @test_table3__field1 ) OR ( test_table3.field2 = @test_table3__field2 ) OR ( test_table3.field2 IN (@test_table3__field20,@test_table3__field21) ) AND (  ( test_table3.field1 >= @test_table3__field1 ) AND ( test_table3.field1 <= @test_table3__field1 ) OR ( test_table3.field1 <= @test_table3__field1 ) OR ( test_table3.field2 = @test_table3__field2 ) OR ( test_table3.field2 IN (@test_table3__field20,@test_table3__field21) )  ) ", expression);

        }
        [Test]
        public void ComplexConditionTest2()
        {

            ComplexCondition condition = new ComplexCondition();
            condition.AddCondition(new ColumnValueCondition(field1, 1, ">="));
            condition.AddCondition("AND", new StringCondition("field1 = @field1", "@field1", field1, 1));

            string expression = condition.BuildCondition();
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual(" ( test_table3.field1 >= @test_table3__field1 ) AND ( field1 = @field1 ) ", expression);

        }
        [Test]
        public void StringConditionTest()
        {

            StringCondition condition = new StringCondition("field1 = @field1","@field1",field1,1);
            string expression = condition.BuildCondition();
            System.Diagnostics.Trace.WriteLine(expression);
            Assert.AreEqual("field1 = @field1",expression);

        }
    }
}
