using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Configuration; // remember to add reference in project
using System.IO;

using NUnit.Framework;
namespace CFWDatabaseTest
{
    [TestFixture]
    public class SqlServerConnectionTest
    {
        [Test]
        public void GetConnectionTest()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            Assert.IsNotNull(con);


        }
        [Test]
        public void ExecuteQuery()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @field1";
            command.SetParameter(new CFW.Database.Parameter( "@field1",DbType.Int32,1));

            DataSet result = con.ExecuteQuery(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);


            con.Close();
        }
        [Test]
        public void ExecuteQuery2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @p1 or field1 = @p2 order by field1";
            command.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));
            command.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));

            DataSet result = con.ExecuteQuery(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(2, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);

            row = result.Tables[0].Rows[1];
            Assert.AreEqual(2, row["field1"]);
            Assert.AreEqual("bbbb", row["field2"]);
            Assert.AreEqual(new DateTime(2002, 3, 4), row["field3"]);
            Assert.AreEqual(222.34M, row["field4"]);
            Assert.AreEqual(20, row["field5"]);
            Assert.AreEqual(200, row["field6_sub1"]);
            Assert.AreEqual(2000, row["field6_sub2"]);

            con.Close();
        }
        [Test]
        public void ExecuteQuery3()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("default");

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @field1";
            command.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 1));

            DataSet result = con.ExecuteQuery(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);


            con.Close();
        }
        [Test]
        public void ExecuteQuery4()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("default");

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @field1";
            command.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 1));
            command.SetConnection(con);

            DataSet result = command.ExecuteQuery();
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);


            con.Close();
        }
        [Test]
        public void ExecuteReader()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @field1";
            command.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 1));

            DbDataReader reader = con.ExecuteReader(command);
            Assert.IsNotNull(reader);
            Assert.IsTrue(reader.Read());
            Assert.AreEqual(1, reader.GetValue(reader.GetOrdinal("field1")));
            Assert.AreEqual("aaaa", reader.GetValue(reader.GetOrdinal("field2")));
            Assert.AreEqual(new DateTime(2001, 2, 3), reader.GetValue(reader.GetOrdinal("field3")));
            Assert.AreEqual(102.34M, reader.GetValue(reader.GetOrdinal("field4")));
            Assert.AreEqual(10, reader.GetValue(reader.GetOrdinal("field5")));
            Assert.AreEqual(100, reader.GetValue(reader.GetOrdinal("field6_sub1")));
            Assert.AreEqual(1000, reader.GetValue(reader.GetOrdinal("field6_sub2")));
            reader.Close();

            con.Close();
        }
        [Test]
        public void ExecuteReader2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @p1 or field1 = @p2 order by field1";
            command.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));
            command.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));


            DbDataReader reader = con.ExecuteReader(command);
            Assert.IsNotNull(reader);
            Assert.IsTrue(reader.Read());
            Assert.AreEqual(1, reader.GetValue(reader.GetOrdinal("field1")));
            Assert.AreEqual("aaaa", reader.GetValue(reader.GetOrdinal("field2")));
            Assert.AreEqual(new DateTime(2001, 2, 3), reader.GetValue(reader.GetOrdinal("field3")));
            Assert.AreEqual(102.34M, reader.GetValue(reader.GetOrdinal("field4")));
            Assert.AreEqual(10, reader.GetValue(reader.GetOrdinal("field5")));
            Assert.AreEqual(100, reader.GetValue(reader.GetOrdinal("field6_sub1")));
            Assert.AreEqual(1000, reader.GetValue(reader.GetOrdinal("field6_sub2")));

            Assert.IsTrue(reader.Read());
            Assert.AreEqual(2, reader.GetValue(reader.GetOrdinal("field1")));
            Assert.AreEqual("bbbb", reader.GetValue(reader.GetOrdinal("field2")));
            Assert.AreEqual(new DateTime(2002, 3, 4), reader.GetValue(reader.GetOrdinal("field3")));
            Assert.AreEqual(222.34M, reader.GetValue(reader.GetOrdinal("field4")));
            Assert.AreEqual(20, reader.GetValue(reader.GetOrdinal("field5")));
            Assert.AreEqual(200, reader.GetValue(reader.GetOrdinal("field6_sub1")));
            Assert.AreEqual(2000, reader.GetValue(reader.GetOrdinal("field6_sub2")));

            Assert.IsFalse(reader.Read());
            reader.Close();

            con.Close();
        }
        [Test]
        public void ExecuteReader3()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @p1 or field1 = @p2 order by field1";
            command.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));
            command.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));
            command.SetConnection(con);

            DbDataReader reader = command.ExecuteReader();
            Assert.IsNotNull(reader);
            Assert.IsTrue(reader.Read());
            Assert.AreEqual(1, reader.GetValue(reader.GetOrdinal("field1")));
            Assert.AreEqual("aaaa", reader.GetValue(reader.GetOrdinal("field2")));
            Assert.AreEqual(new DateTime(2001, 2, 3), reader.GetValue(reader.GetOrdinal("field3")));
            Assert.AreEqual(102.34M, reader.GetValue(reader.GetOrdinal("field4")));
            Assert.AreEqual(10, reader.GetValue(reader.GetOrdinal("field5")));
            Assert.AreEqual(100, reader.GetValue(reader.GetOrdinal("field6_sub1")));
            Assert.AreEqual(1000, reader.GetValue(reader.GetOrdinal("field6_sub2")));

            Assert.IsTrue(reader.Read());
            Assert.AreEqual(2, reader.GetValue(reader.GetOrdinal("field1")));
            Assert.AreEqual("bbbb", reader.GetValue(reader.GetOrdinal("field2")));
            Assert.AreEqual(new DateTime(2002, 3, 4), reader.GetValue(reader.GetOrdinal("field3")));
            Assert.AreEqual(222.34M, reader.GetValue(reader.GetOrdinal("field4")));
            Assert.AreEqual(20, reader.GetValue(reader.GetOrdinal("field5")));
            Assert.AreEqual(200, reader.GetValue(reader.GetOrdinal("field6_sub1")));
            Assert.AreEqual(2000, reader.GetValue(reader.GetOrdinal("field6_sub2")));

            Assert.IsFalse(reader.Read());
            reader.Close();

            con.Close();
        }

        [Test]
        public void ExecuteUpdate()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();

            CFW.Database.Command insert = new CFW.Database.Command();
            insert.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "ZZZZ"));
            insert.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal, 101101.56M, 10, 2));
            insert.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10100));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 101000));

            int result = con.ExecuteUpdate(insert);
            Assert.Greater(result, 0);
            con.Close();
            //ǉf[^݊mF
            con.Open();
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            DataSet resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("ZZZZ", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //update
            con.Open();

            CFW.Database.Command update = new CFW.Database.Command();
            update.Text = "update  test_table3 set field2 = @field2,field3 = @field3 where field1 = @field1";
            update.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            update.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "YYYY"));
            update.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1970, 12, 23, 10, 11, 55)));

            result = con.ExecuteUpdate(update);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("YYYY", row["field2"]);
            Assert.AreEqual(new DateTime(1970, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //delete
            con.Open();

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete test_table3 where field1 = @field1";
            delete.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));

            result = con.ExecuteUpdate(delete);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);


            con.Close();
        }
        [Test]
        public void ExecuteUpdate2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();

            CFW.Database.Command insert = new CFW.Database.Command();
            insert.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "ZZZZ"));
            insert.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal, 101101.56M, 10, 2));
            insert.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10100));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 101000));
            insert.SetConnection(con);
            int result = insert.ExecuteUpdate();
            Assert.Greater(result, 0);
            con.Close();
            //ǉf[^݊mF
            con.Open();
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            select.SetConnection(con);
            DataSet resultSet = select.ExecuteQuery();
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("ZZZZ", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //update
            con.Open();

            CFW.Database.Command update = new CFW.Database.Command();
            update.Text = "update  test_table3 set field2 = @field2,field3 = @field3 where field1 = @field1";
            update.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            update.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "YYYY"));
            update.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1970, 12, 23, 10, 11, 55)));
            update.SetConnection(con);
            result = update.ExecuteUpdate();
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            select.SetConnection(con);
            resultSet = select.ExecuteQuery();

            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("YYYY", row["field2"]);
            Assert.AreEqual(new DateTime(1970, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //delete
            con.Open();

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete test_table3 where field1 = @field1";
            delete.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            delete.SetConnection(con);
            result = delete.ExecuteUpdate();
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            select.SetConnection(con);
            resultSet = select.ExecuteQuery();

            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);


            con.Close();
        }
        [Test]
        public void ExecuteQueryAsTableRows()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @p1 or field1 = @p2 order by field1";
            command.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));
            command.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));

            List<TestTableRow> result = con.ExecuteQueryAsTableRows<TestTableRow>(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Count);

            TestTableRow row = result[0];
            Assert.AreEqual(1, row.Field1);
            Assert.AreEqual("aaaa", row.Field2);
            Assert.AreEqual(new DateTime(2001, 2, 3), row.Field3);
            Assert.AreEqual(102.34M, row.Field4);
            Assert.AreEqual(10, row.Field5);
            Assert.AreEqual(100, row.Field6Sub1);
            Assert.AreEqual(1000, row.Field6Sub2);

            row = result[1];
            Assert.AreEqual(2, row.Field1);
            Assert.AreEqual("bbbb", row.Field2);
            Assert.AreEqual(new DateTime(2002, 3, 4), row.Field3);
            Assert.AreEqual(222.34M, row.Field4);
            Assert.AreEqual(20, row.Field5);
            Assert.AreEqual(200, row.Field6Sub1);
            Assert.AreEqual(2000, row.Field6Sub2);

            con.Close();
        }
        [Test]
        public void ExecuteQueryBatch()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command1 = new CFW.Database.Command();
            command1.Text = "select * from test_table3 where field1 = @p1 order by field1";
            command1.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));

            CFW.Database.Command command2 = new CFW.Database.Command();
            command2.Text = "select * from test_table3 where field1 = @p2 order by field1";
            command2.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));


            DataSet result = con.ExecuteQueryBatch(new CFW.Database.Command[] { command1, command2 });
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);
            Assert.AreEqual(1, result.Tables[1].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);

            row = result.Tables[1].Rows[0];
            Assert.AreEqual(2, row["field1"]);
            Assert.AreEqual("bbbb", row["field2"]);
            Assert.AreEqual(new DateTime(2002, 3, 4), row["field3"]);
            Assert.AreEqual(222.34M, row["field4"]);
            Assert.AreEqual(20, row["field5"]);
            Assert.AreEqual(200, row["field6_sub1"]);
            Assert.AreEqual(2000, row["field6_sub2"]);

            con.Close();
        }

        [Test]
        public void ExecuteUpdateBatch()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();

            CFW.Database.Command insert1 = new CFW.Database.Command();
            insert1.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert1.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            insert1.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "ZZZZ"));
            insert1.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert1.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal, 101101.56M, 10, 2));
            insert1.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 101));
            insert1.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10100));
            insert1.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 101000));

            CFW.Database.Command insert2 = new CFW.Database.Command();
            insert2.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert2.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 102));
            insert2.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "XXXX"));
            insert2.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert2.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal, 101102.56M, 10, 2));
            insert2.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 102));
            insert2.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10200));
            insert2.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 102000));

            int result = con.ExecuteUpdateBatch(new CFW.Database.Command[] { insert1, insert2 });
            Assert.Greater(result, 0);
            con.Close();
            //ǉf[^݊mF
            con.Open();
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 in ( @p1 , @p2)";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            select.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 102));

            DataSet resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(2, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("ZZZZ", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            row = resultSet.Tables[0].Rows[1];
            Assert.AreEqual(102, row["field1"]);
            Assert.AreEqual("XXXX", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101102.56M, row["field4"]);
            Assert.AreEqual(102, row["field5"]);
            Assert.AreEqual(10200, row["field6_sub1"]);
            Assert.AreEqual(102000, row["field6_sub2"]);

            con.Close();


            //delete
            con.Open();

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete test_table3 where field1  in ( @p1 , @p2)";
            delete.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            delete.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 102));

            result = con.ExecuteUpdate(delete);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 in ( @p1 , @p2)";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            select.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 102));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);


            con.Close();
        }
        [Test]
        public void ListTables()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();

            DataSet tablesSet = con.ListTables("acl%");

            Assert.IsNotNull(tablesSet);
            Assert.AreEqual(1, tablesSet.Tables.Count);
            Assert.AreEqual(3, tablesSet.Tables[0].Rows.Count);

            DataRow row = tablesSet.Tables[0].Rows[0];
            Assert.AreEqual("acl_resources", row["TABLE_NAME"]);

            row = tablesSet.Tables[0].Rows[1];
            Assert.AreEqual("acl_roles", row["TABLE_NAME"]);

            row = tablesSet.Tables[0].Rows[2];
            Assert.AreEqual("acl_rules", row["TABLE_NAME"]);

            con.Close();
        }
        [Test]
        public void Implode()
        {
        }
        [Test]
        public void GetIdentity()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();
            con.BeginTransaction();
            CFW.Database.Command command = new CFW.Database.Command("insert into keyValueTable(name) values('aiueo')");
            int result = con.ExecuteUpdate(command);
            int id = con.GetLastIdentity();

            Assert.Greater(result, 0);
            Assert.Greater(id, 0);

            con.CommitTransaction();
            con.Close();

        }
        [Test]
        public void ExceptionTest()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                //ǉ
                con.Open();
                CFW.Database.Command command = new CFW.Database.Command("select aaaa from bbbb");
                //Oo͂Ȃ̂Ŗ߂l
                con.ExecuteQuery(command);
            }
            catch (Exception ex)
            {
                Assert.IsInstanceOfType(typeof(CFW.Database.ConnectionException), ex);
                CFW.Database.ConnectionException cex = ex as CFW.Database.ConnectionException;
                Assert.IsNotNull(cex);

                CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
            }
            finally
            {
                con.Close();
            }
        }
        [Test]
        public void ExceptionTest2()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                //ǉ
                con.Open();
                CFW.Database.Command command = new CFW.Database.Command("insert into auth_users (login_id,name,password,description) values(@login_id,@name,@password,@description)");
                command.SetParameter(new CFW.Database.Parameter("@login_id", DbType.String, "m-okada"));
                command.SetParameter(new CFW.Database.Parameter("@name", DbType.String, "michiaki okada"));
                command.SetParameter(new CFW.Database.Parameter("@password", DbType.String, "80ecbfc4f9ac535b12ec865735184993"));
                command.SetParameter(new CFW.Database.Parameter("@description",DbType.String,"deXg"));
                //Oo͂Ȃ̂Ŗ߂l
                con.ExecuteQuery(command);
            }
            catch (Exception ex)
            {
                Assert.IsInstanceOfType(typeof(CFW.Database.ConnectionException), ex);
                CFW.Database.ConnectionException cex = ex as CFW.Database.ConnectionException;
                Assert.IsNotNull(cex);
                Assert.AreEqual(2627, cex.ErrorNumber);

                CFW.ErrorHandler.ErrorMessageBuilder builder = CFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                builder.WriteLog();
            }
            finally
            {
                con.Close();
            }
        }
        [Test]
        public void StoredProcedureTest()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                //ǉ
                con.Open();
                CFW.Database.Command command = new CFW.Database.Command("sampleProcedure",CommandType.StoredProcedure);
                command.SetParameter(new CFW.Database.Parameter("@p1", DbType.String, "A001",10));
                CFW.Database.Parameter p2 = new CFW.Database.Parameter("@p2", DbType.String,null,10);
                p2.ParameterDirection = ParameterDirection.Output;
                command.SetParameter(p2);
                DataSet result =  con.ExecuteQuery(command);
                foreach (CFW.Database.Parameter p in command.Parameters)
                {
                    System.Diagnostics.Trace.WriteLine("p.value = " + p.ParameterValue);

                }
                Assert.AreEqual("A001", command.Parameters[0].ParameterValue);
                Assert.AreEqual("eXg1111a", command.Parameters[1].ParameterValue);
                Assert.AreEqual("eXg1111a", p2.ParameterValue);
                Assert.AreEqual(1, result.Tables[0].Rows.Count);

            }
            finally
            {
                con.Close();
            }
        }
        [Test]
        public void returns()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            try
            {
                //ǉ
                con.Open();
                DataSet columns = con.GetColumnInfo("test_table4");

                DataRowCollection rows = columns.Tables[0].Rows;
                Assert.AreEqual(12, rows.Count);

                CFW.FieldProperties.FieldProperty p = null;//錾

                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[0]);
                Assert.AreEqual("int", p.sqlTypeName);
                Assert.AreEqual("id", p.FieldName);
                Assert.AreEqual(4, p.Length);
                Assert.AreEqual(10, p.Precision);
                Assert.AreEqual(0, p.Scale);

                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[1]);
                Assert.AreEqual("int", p.sqlTypeName);
                Assert.AreEqual("int_field", p.FieldName);
                Assert.AreEqual(4, p.Length);
                Assert.AreEqual(10, p.Precision);
                Assert.AreEqual(0, p.Scale);

                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[2]);
                Assert.AreEqual("smallint", p.sqlTypeName);
                Assert.AreEqual("smallint_field", p.FieldName);
                Assert.AreEqual(2, p.Length);
                Assert.AreEqual(5, p.Precision);
                Assert.AreEqual(0, p.Scale);


                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[3]);
                Assert.AreEqual("bigint", p.sqlTypeName);
                Assert.AreEqual("long_field", p.FieldName);
                Assert.AreEqual(8, p.Length);
                Assert.AreEqual(19, p.Precision);
                Assert.AreEqual(0, p.Scale);


                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[4]);
                Assert.AreEqual("tinyint", p.sqlTypeName);
                Assert.AreEqual("tinyint_field", p.FieldName);
                Assert.AreEqual(1, p.Length);
                Assert.AreEqual(3, p.Precision);
                Assert.AreEqual(0, p.Scale);


                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[5]);
                Assert.AreEqual("char", p.sqlTypeName);
                Assert.AreEqual("char_field", p.FieldName);
                Assert.AreEqual(1000, p.Length);
                Assert.AreEqual(1000, p.Precision);
                Assert.AreEqual(0, p.Scale);


                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[6]);
                Assert.AreEqual("varchar", p.sqlTypeName);
                Assert.AreEqual("varchar_field", p.FieldName);
                Assert.AreEqual(1000, p.Length);
                Assert.AreEqual(1000, p.Precision);
                Assert.AreEqual(0, p.Scale);

                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[7]);
                Assert.AreEqual("nchar", p.sqlTypeName);
                Assert.AreEqual("nchar_field", p.FieldName);
                Assert.AreEqual(2000, p.Length);
                Assert.AreEqual(1000, p.Precision);
                Assert.AreEqual(0, p.Scale);

                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[8]);
                Assert.AreEqual("nvarchar", p.sqlTypeName);
                Assert.AreEqual("nvarchar_Field", p.FieldName);
                Assert.AreEqual(2000, p.Length);
                Assert.AreEqual(1000, p.Precision);
                Assert.AreEqual(0, p.Scale);

                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[9]);
                Assert.AreEqual("datetime", p.sqlTypeName);
                Assert.AreEqual("datetime_field", p.FieldName);
                Assert.AreEqual(16, p.Length);
                Assert.AreEqual(23, p.Precision);
                Assert.AreEqual(3, p.Scale);

                p = CFW.FieldProperties.FieldProperty.NewInstance(rows[10]);
                Assert.AreEqual("smalldatetime", p.sqlTypeName);
                Assert.AreEqual("smalldatetime_field", p.FieldName);
                Assert.AreEqual(16, p.Length);
                Assert.AreEqual(16, p.Precision);
                Assert.AreEqual(0, p.Scale);
            }
            finally
            {
                con.Close();
            }
        }
        [Test]
        public void ExecuteSerialize()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("default");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @field1";
            command.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 1));

            string result = con.ExecuteQueryAsSerialized(command);
            Assert.IsNotNull(result);
            System.Diagnostics.Trace.WriteLine(result);

            DataSet resultSet = con.ExecuteQuery(command);
            CFW.Serializer.DataSXSerializer serializer = new CFW.Serializer.DataSXSerializer();
            StringWriter writer = new StringWriter();
             serializer.SerializeDataSet(writer, resultSet);
            System.Diagnostics.Trace.WriteLine(writer.ToString());

            con.Close();
        }
    }
}
