using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using CFW;
using CFW.Database;
using NUnit.Framework;

namespace CFWDatabaseTest.SQLite
{
    [NUnit.Framework.TestFixture]
    public class SQLiteConnectionTest
    {
        [Test(Description="PȑING[s")]
        public void ExecuteQuery()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("sqlite");

            con.Open();
            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test1 where id = @id";
            command.SetParameter(new CFW.Database.Parameter("@id", DbType.Int32, 1));

            DataSet result = con.ExecuteQuery(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["id"]);
            Assert.AreEqual("2", row["field1"]);
            Assert.AreEqual(DateTime.Parse("2001-02-03 04:05:06"),CFW.Util.DateUtil.DateValue( row["field2"]) );

            con.Close();
        }
        [Test(Description = "PȑING[s(System.Data.SQLite.SQLiteConnectionɒڐڑ)")]
        public void ExecuteQueryA()
        {
            System.Data.SQLite.SQLiteConnection con = new System.Data.SQLite.SQLiteConnection("Data Source=test.db3");
            con.Open();

            System.Data.SQLite.SQLiteCommand command = new System.Data.SQLite.SQLiteCommand("select * from test1 where id = 1", con);
            System.Data.SQLite.SQLiteDataAdapter da = new System.Data.SQLite.SQLiteDataAdapter();
            da.SelectCommand = command;


            DataSet result = new DataSet() ;
            da.Fill(result);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["id"]);
            Assert.AreEqual("2", row["field1"]);
            Assert.AreEqual(DateTime.Parse("2001/2/3 4:05:06"),CFW.Util.DateUtil.DateValue(  row["field2"] ));

            con.Close();
        }
        [Test(Description = "PȍXVNG[s")]
        public void ExecuteUpdate()
        {
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnectionByName("sqlite");

            //ǉ
            con.Open();

            CFW.Database.Command insert = new CFW.Database.Command();
            insert.Text = "insert into test1 values(@id,@field1,@field2,@field3)";
            insert.SetParameter(new CFW.Database.Parameter("@id", DbType.Int32, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field1", DbType.String, "ZZZZ"));
            insert.SetParameter(new CFW.Database.Parameter("@field2", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert.SetParameter(new CFW.Database.Parameter("@field3", DbType.Decimal, 101101.56M, 10, 2));

            int result = con.ExecuteUpdate(insert);
            Assert.Greater(result, 0);
            con.Close();
            //ǉf[^݊mF
            con.Open();
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test1 where id = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            DataSet resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["id"]);
            Assert.AreEqual("ZZZZ", row["field1"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), CFW.Util.DateUtil.DateValue( row["field2"] ));
            Assert.AreEqual(101101.56M, row["field3"]);

            con.Close();

            //update
            con.Open();

            CFW.Database.Command update = new CFW.Database.Command();
            update.Text = "update  test1 set field1 = @field1,field2 = @field2 where id = @id ";
            update.SetParameter(new CFW.Database.Parameter("@id", DbType.Int32, 101));
            update.SetParameter(new CFW.Database.Parameter("@field1", DbType.String, "YYYY"));
            update.SetParameter(new CFW.Database.Parameter("@field2", DbType.DateTime, new DateTime(1970, 12, 23, 10, 11, 55)));

            result = con.ExecuteUpdate(update);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test1 where id = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["id"]);
            Assert.AreEqual("YYYY", row["field1"]);
            Assert.AreEqual(new DateTime(1970, 12, 23, 10, 11, 55),CFW.Util.DateUtil.DateValue(  row["field2"] ));
            Assert.AreEqual(101101.56M, row["field3"]);

            con.Close();

            //delete
            con.Open();

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete from test1 where id = @id";
            delete.SetParameter(new CFW.Database.Parameter("@id", DbType.Int32, 101));

            result = con.ExecuteUpdate(delete);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test1 where id = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);


            con.Close();
        }

    }
}
