using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Configuration; // remember to add reference in project
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using NUnit.Framework;
namespace CFWDatabaseTest.DbWebServiceReference
{
    [NUnit.Framework.TestFixture]
    public class ConnectionTest
    {
        FieldProperty field1;
        FieldProperty field2;
        FieldProperty field3;
        FieldProperty field4;
        FieldProperty field5;
        FieldProperty field6Sub1;
        FieldProperty field6Sub2;

        
        [NUnit.Framework.SetUp]
        public void init()
        {
            field1 = FieldProperty.NewInstance("int", "test_table3", "field1", "[field1]", 4, 10, 0, false, 0, true);
            field2 = FieldProperty.NewInstance("varchar", "test_table3", "field2", "[field2]", 50, 0, 0, false, "", false);
            field3 = FieldProperty.NewInstance("datetime", "test_table3", "field3", "[field3]", 16, 23, 3, true, null, false);
            field4 = FieldProperty.NewInstance("decimal", "test_table3", "field4", "[field4]", 12, 10, 2, true, null, false);
            field5 = FieldProperty.NewInstance("smallint", "test_table3", "field5", "[field5]", 2, 5, 0, true, null, false);
            field6Sub1 = FieldProperty.NewInstance("int", "test_table3", "field6_sub1", "[field6_sub1]", 4, 10, 0, true, null, false);
            field6Sub2 = FieldProperty.NewInstance("int", "test_table3", "field6_sub2", "[field6_sub2]", 4, 10, 0, true, null, false);

        }

        [NUnit.Framework.Test]
        public void ExecuteQueryTest()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command( "select * from test_table3 where field1 = @field1",CommandType.Text);
            command.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 1));

            DataSet result = con.ExecuteQuery(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);


            con.Close();
        }
        [NUnit.Framework.Test]
        public void ExecuteQueryTest4()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();
            CFW.Database.TableCommand.TableSelectCommand command = new CFW.Database.TableCommand.TableSelectCommand("test_table3");
            command.AddSelect(field1);
            command.AddSelect(field2);
            command.AddSelect(field3);
            command.AddSelect(field4);
            command.AddSelect(field5);
            command.AddSelect(field6Sub1);
            command.AddSelect(field6Sub2);

            command.AddWhere(new ColumnValueCondition(field1, 1, "="));

            List<TestTableRow> testList = con.ExecuteQueryAsTableRows<TestTableRow>(command.GetCommand());
            con.Close();

            Assert.IsNotNull(testList);
            Assert.AreEqual(1, testList.Count);

            TestTableRow row = testList[0];
            Assert.AreEqual(1, row.Field1);
            Assert.AreEqual("aaaa", row.Field2);
            Assert.AreEqual(new DateTime(2001, 2, 3), row.Field3);
            Assert.AreEqual(102.34M, row.Field4);
            Assert.AreEqual(10, row.Field5);
            Assert.AreEqual(100, row.Field6Sub1);
            Assert.AreEqual(1000, row.Field6Sub2);
        }

        [Test]
        public void ExecuteQuery2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @p1 or field1 = @p2 order by field1";
            command.CommandType = CommandType.Text;
            command.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));
            command.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));

            DataSet result = con.ExecuteQuery(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(2, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);

            row = result.Tables[0].Rows[1];
            Assert.AreEqual(2, row["field1"]);
            Assert.AreEqual("bbbb", row["field2"]);
            Assert.AreEqual(new DateTime(2002, 3, 4), row["field3"]);
            Assert.AreEqual(222.34M, row["field4"]);
            Assert.AreEqual(20, row["field5"]);
            Assert.AreEqual(200, row["field6_sub1"]);
            Assert.AreEqual(2000, row["field6_sub2"]);

            con.Close();
        }
        [Test]
        public void ExecuteQuery3()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @field1";
            command.CommandType = CommandType.Text;
            command.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 1));

            DataSet result = con.ExecuteQuery(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(1, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);


            con.Close();
        }
        [Test]
        public void ExecuteUpdate()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();

            CFW.Database.Command insert = new CFW.Database.Command();
            insert.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert.CommandType = CommandType.Text;
            insert.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "ZZZZ"));
            insert.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal, 101101.56M, 10, 2));
            insert.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10100));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 101000));

            int result = con.ExecuteUpdate(insert);
            Assert.Greater(result, 0);
            con.Close();
            //ǉf[^݊mF
            con.Open();
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            DataSet resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("ZZZZ", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //update
            con.Open();

            CFW.Database.Command update = new CFW.Database.Command();
            update.Text = "update  test_table3 set field2 = @field2,field3 = @field3 where field1 = @field1";
            update.CommandType = CommandType.Text;
            update.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            update.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "YYYY"));
            update.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1970, 12, 23, 10, 11, 55)));

            result = con.ExecuteUpdate(update);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.CommandType = CommandType.Text;
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("YYYY", row["field2"]);
            Assert.AreEqual(new DateTime(1970, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //delete
            con.Open();

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete test_table3 where field1 = @field1";
            delete.CommandType = CommandType.Text;
            delete.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));

            result = con.ExecuteUpdate(delete);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.CommandType = CommandType.Text;
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);


            con.Close();
        }
        [Test]
        public void ExecuteUpdate2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();

            CFW.Database.Command insert = new CFW.Database.Command();
            insert.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert.CommandType = CommandType.Text;
            insert.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "ZZZZ"));
            insert.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal,null));
            insert.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 101));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10100));
            insert.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 101000));

            int result = con.ExecuteUpdate(insert);
            Assert.Greater(result, 0);
            con.Close();
            //ǉf[^݊mF
            con.Open();
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            DataSet resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("ZZZZ", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(DBNull.Value, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //update
            con.Open();

            CFW.Database.Command update = new CFW.Database.Command();
            update.Text = "update  test_table3 set field2 = @field2,field3 = @field3 where field1 = @field1";
            update.CommandType = CommandType.Text;
            update.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            update.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "YYYY"));
            update.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1970, 12, 23, 10, 11, 55)));

            result = con.ExecuteUpdate(update);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.CommandType = CommandType.Text;
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(1, resultSet.Tables[0].Rows.Count);

            row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("YYYY", row["field2"]);
            Assert.AreEqual(new DateTime(1970, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(DBNull.Value, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            con.Close();

            //delete
            con.Open();

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete test_table3 where field1 = @field1";
            delete.CommandType = CommandType.Text;
            delete.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));

            result = con.ExecuteUpdate(delete);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 = @p1";
            select.CommandType = CommandType.Text;
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);


            con.Close();
        }
        [Test]
        public void ExecuteQueryAsTableRows()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = "select * from test_table3 where field1 = @p1 or field1 = @p2 order by field1";
            command.CommandType = CommandType.Text;
            command.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));
            command.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));

            List<TestTableRow> result = con.ExecuteQueryAsTableRows<TestTableRow>(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Count);

            TestTableRow row = result[0];
            Assert.AreEqual(1, row.Field1);
            Assert.AreEqual("aaaa", row.Field2);
            Assert.AreEqual(new DateTime(2001, 2, 3), row.Field3);
            Assert.AreEqual(102.34M, row.Field4);
            Assert.AreEqual(10, row.Field5);
            Assert.AreEqual(100, row.Field6Sub1);
            Assert.AreEqual(1000, row.Field6Sub2);

            row = result[1];
            Assert.AreEqual(2, row.Field1);
            Assert.AreEqual("bbbb", row.Field2);
            Assert.AreEqual(new DateTime(2002, 3, 4), row.Field3);
            Assert.AreEqual(222.34M, row.Field4);
            Assert.AreEqual(20, row.Field5);
            Assert.AreEqual(200, row.Field6Sub1);
            Assert.AreEqual(2000, row.Field6Sub2);

            con.Close();
        }
        [Test]
        public void ExecuteQueryAsTableRows2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command = new CFW.Database.Command();
            command.Text = @"select t1.field1 as t1__field1,
 t1.field2 as t1__field2,
 t1.field3 as t1__field3,
 t1.field4 as t1__field4,
 t1.field5 as t1__field5,
 t1.field6_sub1 as t1__field6_sub1,
 t1.field6_sub2 as t1__field6_sub2
                from test_table3  as t1
where field1 = @p1 or field1 = @p2 order by field1";
            command.CommandType = CommandType.Text;
            command.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));
            command.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));

            List<TestTableRow> result = con.ExecuteQueryAsTableRows<TestTableRow>(command);
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Count);

            TestTableRow row = result[0];
            Assert.AreEqual(1, row.Field1);
            Assert.AreEqual("aaaa", row.Field2);
            Assert.AreEqual(new DateTime(2001, 2, 3), row.Field3);
            Assert.AreEqual(102.34M, row.Field4);
            Assert.AreEqual(10, row.Field5);
            Assert.AreEqual(100, row.Field6Sub1);
            Assert.AreEqual(1000, row.Field6Sub2);

            row = result[1];
            Assert.AreEqual(2, row.Field1);
            Assert.AreEqual("bbbb", row.Field2);
            Assert.AreEqual(new DateTime(2002, 3, 4), row.Field3);
            Assert.AreEqual(222.34M, row.Field4);
            Assert.AreEqual(20, row.Field5);
            Assert.AreEqual(200, row.Field6Sub1);
            Assert.AreEqual(2000, row.Field6Sub2);

            con.Close();
        }
        [Test]
        public void ExecuteQueryBatch()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            con.Open();

            CFW.Database.Command command1 = new CFW.Database.Command();
            command1.Text = "select * from test_table3 where field1 = @p1 order by field1";
            command1.CommandType = CommandType.Text;
            command1.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 1));

            CFW.Database.Command command2 = new CFW.Database.Command();
            command2.Text = "select * from test_table3 where field1 = @p2 order by field1";
            command2.CommandType = CommandType.Text;
            command2.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 2));


            DataSet result = con.ExecuteQueryBatch(new CFW.Database.Command[] { command1, command2 });
            Assert.IsNotNull(result);
            Assert.AreEqual(2, result.Tables.Count);
            Assert.AreEqual(1, result.Tables[0].Rows.Count);
            Assert.AreEqual(1, result.Tables[1].Rows.Count);

            DataRow row = result.Tables[0].Rows[0];
            Assert.AreEqual(1, row["field1"]);
            Assert.AreEqual("aaaa", row["field2"]);
            Assert.AreEqual(new DateTime(2001, 2, 3), row["field3"]);
            Assert.AreEqual(102.34M, row["field4"]);
            Assert.AreEqual(10, row["field5"]);
            Assert.AreEqual(100, row["field6_sub1"]);
            Assert.AreEqual(1000, row["field6_sub2"]);

            row = result.Tables[1].Rows[0];
            Assert.AreEqual(2, row["field1"]);
            Assert.AreEqual("bbbb", row["field2"]);
            Assert.AreEqual(new DateTime(2002, 3, 4), row["field3"]);
            Assert.AreEqual(222.34M, row["field4"]);
            Assert.AreEqual(20, row["field5"]);
            Assert.AreEqual(200, row["field6_sub1"]);
            Assert.AreEqual(2000, row["field6_sub2"]);

            con.Close();
        }

        [Test]
        public void ExecuteUpdateBatch()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            //ǉ
            con.Open();

            CFW.Database.Command insert1 = new CFW.Database.Command();
            insert1.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert1.CommandType = CommandType.Text;
            insert1.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 101));
            insert1.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "ZZZZ"));
            insert1.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert1.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal, 101101.56M, 10, 2));
            insert1.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 101));
            insert1.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10100));
            insert1.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 101000));

            CFW.Database.Command insert2 = new CFW.Database.Command();
            insert2.Text = "insert into test_table3 values(@field1,@field2,@field3,@field4,@field5,@field6_sub1,@field6_sub2)";
            insert2.CommandType = CommandType.Text;
            insert2.SetParameter(new CFW.Database.Parameter("@field1", DbType.Int32, 102));
            insert2.SetParameter(new CFW.Database.Parameter("@field2", DbType.String, "XXXX"));
            insert2.SetParameter(new CFW.Database.Parameter("@field3", DbType.DateTime, new DateTime(1965, 12, 23, 10, 11, 55)));
            insert2.SetParameter(new CFW.Database.Parameter("@field4", DbType.Decimal, 101102.56M, 10, 2));
            insert2.SetParameter(new CFW.Database.Parameter("@field5", DbType.Int16, 102));
            insert2.SetParameter(new CFW.Database.Parameter("@field6_sub1", DbType.Int32, 10200));
            insert2.SetParameter(new CFW.Database.Parameter("@field6_sub2", DbType.Int32, 102000));

            int result = con.ExecuteUpdateBatch(new CFW.Database.Command[] { insert1, insert2 });
            Assert.Greater(result, 0);
            con.Close();
            //ǉf[^݊mF
            con.Open();
            CFW.Database.Command select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 in ( @p1 , @p2)";
            select.CommandType = CommandType.Text;
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            select.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 102));

            DataSet resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(2, resultSet.Tables[0].Rows.Count);

            DataRow row = resultSet.Tables[0].Rows[0];
            Assert.AreEqual(101, row["field1"]);
            Assert.AreEqual("ZZZZ", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101101.56M, row["field4"]);
            Assert.AreEqual(101, row["field5"]);
            Assert.AreEqual(10100, row["field6_sub1"]);
            Assert.AreEqual(101000, row["field6_sub2"]);

            row = resultSet.Tables[0].Rows[1];
            Assert.AreEqual(102, row["field1"]);
            Assert.AreEqual("XXXX", row["field2"]);
            Assert.AreEqual(new DateTime(1965, 12, 23, 10, 11, 55), row["field3"]);
            Assert.AreEqual(101102.56M, row["field4"]);
            Assert.AreEqual(102, row["field5"]);
            Assert.AreEqual(10200, row["field6_sub1"]);
            Assert.AreEqual(102000, row["field6_sub2"]);

            con.Close();


            //delete
            con.Open();

            CFW.Database.Command delete = new CFW.Database.Command();
            delete.Text = "delete test_table3 where field1  in ( @p1 , @p2)";
            delete.CommandType = CommandType.Text;
            delete.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            delete.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 102));

            result = con.ExecuteUpdate(delete);
            Assert.Greater(result, 0);
            con.Close();

            //XVf[^݊mF
            con.Open();
            select = new CFW.Database.Command();
            select.Text = "select * from test_table3 where field1 in ( @p1 , @p2)";
            select.SetParameter(new CFW.Database.Parameter("@p1", DbType.Int32, 101));
            select.SetParameter(new CFW.Database.Parameter("@p2", DbType.Int32, 102));

            resultSet = con.ExecuteQuery(select);
            Assert.IsNotNull(resultSet);
            Assert.AreEqual(1, resultSet.Tables.Count);
            Assert.AreEqual(0, resultSet.Tables[0].Rows.Count);


            con.Close();
        }
        [Test]
        public void Implode()
        {
        }
        [Test]
        public void Update()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            TestTableRow original = new TestTableRow();
            original.Field1 = 101;
            original.Field2 = "1234567890";
            original.Field3 = new DateTime(1970, 2, 3);
            original.Field4 = 123.45M;
            original.Field5 = 101;
            original.Field6Sub1 = 10100;
            original.Field6Sub2 = 101000;


            con.Open();

            CFW.Database.TableCommand.TableInsertCommand command = new CFW.Database.TableCommand.TableInsertCommand("test_table3");
            command.AddInsert(field1, original.Field1);
            command.AddInsert(field2, original.Field2);
            command.AddInsert(field3, original.Field3);
            command.AddInsert(field4, original.Field4);
            command.AddInsert(field5, original.Field5);
            command.AddInsert(field6Sub1, original.Field6Sub1);
            command.AddInsert(field6Sub2, original.Field6Sub2);

            int result = con.ExecuteUpdate(command.GetCommand());
            Assert.Greater(result, 0);

            con.Close();

            con.Open();
            List<TestTableRow> testList = get(101);

            Assert.AreEqual(1, testList.Count);
            TestTableRow row = testList[0];

            Assert.AreEqual(101, row.Field1);
            Assert.AreEqual("1234567890", row.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), row.Field3);
            Assert.AreEqual(123.45M, row.Field4);
            Assert.AreEqual(101, row.Field5);
            Assert.AreEqual(10100, row.Field6Sub1);
            Assert.AreEqual(101000, row.Field6Sub2);
            con.Close();


            con.Open();

            CFW.Database.TableCommand.TableUpdateCommand update = new CFW.Database.TableCommand.TableUpdateCommand("test_table3");
            update.AddUpdate(field2, original.Field2);
            update.AddUpdate(field3, original.Field3);
            update.AddUpdate(field4, original.Field4);
            update.AddUpdate(field5, original.Field5);
            update.AddUpdate(field6Sub1, 10111);
            update.AddUpdate(field6Sub2, 101111);
            update.AddWhere(new ColumnValueCondition(field1, original.Field1, "="));

            result = con.ExecuteUpdate(update.GetCommand());
            Assert.Greater(result, 0);

            con.Close();


            con.Open();

            testList = get(original.Field1);

            Assert.AreEqual(1, testList.Count);
            row = testList[0];

            Assert.AreEqual(101, row.Field1);
            Assert.AreEqual("1234567890", row.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), row.Field3);
            Assert.AreEqual(123.45M, row.Field4);
            Assert.AreEqual(101, row.Field5);
            Assert.AreEqual(10111, row.Field6Sub1);
            Assert.AreEqual(101111, row.Field6Sub2);
            con.Close();

            con.Open();

            CFW.Database.TableCommand.TableDeleteCommand delete = new CFW.Database.TableCommand.TableDeleteCommand("test_table3");
            delete.AddWhere(new ColumnValueCondition(field1, original.Field1, "="));

            result = con.ExecuteUpdate(delete.GetCommand());
            Assert.Greater(result, 0);

            con.Close();


            con.Open();
            testList = get(original.Field1);

            Assert.AreEqual(0, testList.Count);

            con.Close();
        }
        [Test]
        public void Update2()
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);

            TestTableRow original = new TestTableRow();
            original.Field1 = 101;
            original.Field2 = "1234567890";
            original.Field3 = new DateTime(1970, 2, 3);
            original.Field4 = null;
            original.Field5 = 101;
            original.Field6Sub1 = 10100;
            original.Field6Sub2 = 101000;


            con.Open();

            CFW.Database.TableCommand.TableInsertCommand command = new CFW.Database.TableCommand.TableInsertCommand("test_table3");
            command.AddInsert(field1, original.Field1);
            command.AddInsert(field2, original.Field2);
            command.AddInsert(field3, original.Field3);
            command.AddInsert(field4, original.Field4);
            command.AddInsert(field5, original.Field5);
            command.AddInsert(field6Sub1, original.Field6Sub1);
            command.AddInsert(field6Sub2, original.Field6Sub2);

            int result = con.ExecuteUpdate(command.GetCommand());
            Assert.Greater(result, 0);

            con.Close();

            con.Open();
            List<TestTableRow> testList = get(101);

            Assert.AreEqual(1, testList.Count);
            TestTableRow row = testList[0];

            Assert.AreEqual(101, row.Field1);
            Assert.AreEqual("1234567890", row.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), row.Field3);
            Assert.AreEqual(null, row.Field4);
            Assert.AreEqual(101, row.Field5);
            Assert.AreEqual(10100, row.Field6Sub1);
            Assert.AreEqual(101000, row.Field6Sub2);
            con.Close();


            con.Open();

            CFW.Database.TableCommand.TableUpdateCommand update = new CFW.Database.TableCommand.TableUpdateCommand("test_table3");
            update.AddUpdate(field2, original.Field2);
            update.AddUpdate(field3, original.Field3);
            update.AddUpdate(field4, original.Field4);
            update.AddUpdate(field5, original.Field5);
            update.AddUpdate(field6Sub1, 10111);
            update.AddUpdate(field6Sub2, 101111);
            update.AddWhere(new ColumnValueCondition(field1, original.Field1, "="));

            result = con.ExecuteUpdate(update.GetCommand());
            Assert.Greater(result, 0);

            con.Close();


            con.Open();

            testList = get(original.Field1);

            Assert.AreEqual(1, testList.Count);
            row = testList[0];

            Assert.AreEqual(101, row.Field1);
            Assert.AreEqual("1234567890", row.Field2);
            Assert.AreEqual(new DateTime(1970, 2, 3), row.Field3);
            Assert.AreEqual(null, row.Field4);
            Assert.AreEqual(101, row.Field5);
            Assert.AreEqual(10111, row.Field6Sub1);
            Assert.AreEqual(101111, row.Field6Sub2);
            con.Close();

            con.Open();

            CFW.Database.TableCommand.TableDeleteCommand delete = new CFW.Database.TableCommand.TableDeleteCommand("test_table3");
            delete.AddWhere(new ColumnValueCondition(field1, original.Field1, "="));

            result = con.ExecuteUpdate(delete.GetCommand());
            Assert.Greater(result, 0);

            con.Close();


            con.Open();
            testList = get(original.Field1);

            Assert.AreEqual(0, testList.Count);

            con.Close();
        }
        List<TestTableRow> get(int f1)
        {
            CFW.Database.Config.ConnectionConfigElement config = CFW.Database.Config.ConnectionConfigFactory.GetConfig("webService");
            CFW.Database.Connection con = CFW.Database.ConnectionFactory.GetConnection(config);
            con.Open();
            CFW.Database.TableCommand.TableSelectCommand command = new CFW.Database.TableCommand.TableSelectCommand("test_table3");
            command.AddSelect(field1);
            command.AddSelect(field2);
            command.AddSelect(field3);
            command.AddSelect(field4);
            command.AddSelect(field5);
            command.AddSelect(field6Sub1);
            command.AddSelect(field6Sub2);

            command.AddWhere(new ColumnValueCondition(field1, f1, "="));

            List<TestTableRow> testList = con.ExecuteQueryAsTableRows<TestTableRow>(command.GetCommand());
            con.Close();
            return testList;

        }

    }
}
