using System;
using System.Collections.Generic;
using System.Text;
using CFW;
using CFW.Database;
using CFW.Database.Conditions;
using NUnit.Framework;
using CFW.Test.Models;

namespace CFWDatabaseTest
{
    [NUnit.Framework.TestFixture]
    public class DbModelTest
    {
        [Test]
        public void findTest()
        {
            TestTable3Model model = new TestTable3Model();
            TestTable3Property property = new TestTable3Property();
            model.setProperty(property);

            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, 2, "="));

            List<TestTable3Entity> entities = model.find(c);

            Assert.AreEqual(1, entities.Count);
            TestTable3Entity entity = entities[0];
            Assert.AreEqual(2, entity.field1);
            Assert.AreEqual("bbbb", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2002/3/4"), entity.field3);
            Assert.AreEqual(222.34M, entity.field4);
            Assert.AreEqual(20, entity.field5);
            Assert.AreEqual(200, entity.field6Sub1);
            Assert.AreEqual(2000, entity.field6Sub2);


        }
        [Test]
        public void findTest2()
        {
            TestTable3Model model = new TestTable3Model();
            TestTable3Property property = new TestTable3Property();
            model.setProperty(property);

            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, new object[] { 20, 29 }, "BETWEEN"));

            List<TestTable3Entity> entities = model.find(c);

            Assert.AreEqual(10, entities.Count);
            TestTable3Entity entity = entities[0];
            Assert.AreEqual(20, entity.field1);
            Assert.AreEqual("ttt", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 17:00:00"), entity.field3);
            Assert.AreEqual(350.34M, entity.field4);
            Assert.AreEqual(47, entity.field5);
            Assert.AreEqual(317, entity.field6Sub1);
            Assert.AreEqual(3017, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(21, entity.field1);
            Assert.AreEqual("uuu", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 18:00:00"), entity.field3);
            Assert.AreEqual(351.34M, entity.field4);
            Assert.AreEqual(48, entity.field5);
            Assert.AreEqual(318, entity.field6Sub1);
            Assert.AreEqual(3018, entity.field6Sub2);

            entity = entities[9];
            Assert.AreEqual(29, entity.field1);
            Assert.AreEqual("A1000000000001", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/06 2:00:00"), entity.field3);
            Assert.AreEqual(359.34M, entity.field4);
            Assert.AreEqual(56, entity.field5);
            Assert.AreEqual(326, entity.field6Sub1);
            Assert.AreEqual(3026, entity.field6Sub2);


        }
        [Test]
        public void findTest3()
        {
            TestTable3Model model = new TestTable3Model();
            TestTable3Property property = new TestTable3Property();
            model.setProperty(property);

            CFW.Database.Criteria c = new CFW.Database.Criteria();
            c.AddWhere(new ColumnValueCondition(property.field1, new object[] { 20, 21, 29, 1001 }, "IN"));

            List<TestTable3Entity> entities = model.findFromService(c);

            Assert.AreEqual(3, entities.Count);
            TestTable3Entity entity = entities[0];
            Assert.AreEqual(20, entity.field1);
            Assert.AreEqual("ttt", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 17:00:00"), entity.field3);
            Assert.AreEqual(350.34M, entity.field4);
            Assert.AreEqual(47, entity.field5);
            Assert.AreEqual(317, entity.field6Sub1);
            Assert.AreEqual(3017, entity.field6Sub2);

            entity = entities[1];
            Assert.AreEqual(21, entity.field1);
            Assert.AreEqual("uuu", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/05 18:00:00"), entity.field3);
            Assert.AreEqual(351.34M, entity.field4);
            Assert.AreEqual(48, entity.field5);
            Assert.AreEqual(318, entity.field6Sub1);
            Assert.AreEqual(3018, entity.field6Sub2);

            entity = entities[2];
            Assert.AreEqual(29, entity.field1);
            Assert.AreEqual("A1000000000001", entity.field2);
            Assert.AreEqual(CFW.Util.DateUtil.DateValue("2003/04/06 2:00:00"), entity.field3);
            Assert.AreEqual(359.34M, entity.field4);
            Assert.AreEqual(56, entity.field5);
            Assert.AreEqual(326, entity.field6Sub1);
            Assert.AreEqual(3026, entity.field6Sub2);
        }

    }
}
