using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table ProductModelProductDescriptionɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class ProductModelProductDescriptionTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[ProductModelID]</summary>
        public FieldProperty productModelID;
        ///<summary>[ProductDescriptionID]</summary>
        public FieldProperty productDescriptionID;
        ///<summary>[Culture]</summary>
        public FieldProperty culture;
        ///<summary>[ModifiedDate]</summary>
        public FieldProperty modifiedDate;
        

        /// <summary>
        /// default construct
        /// </summary>
        public ProductModelProductDescriptionTableProperty()
        {
            this.EntityName = "ProductModelProductDescription";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            productModelID = FieldProperty.NewInstance("int", "ProductModelProductDescription", "ProductModelID","[ProductModelID]", 4, 10, 0, false, 0,false);
            productDescriptionID = FieldProperty.NewInstance("int", "ProductModelProductDescription", "ProductDescriptionID","[ProductDescriptionID]", 4, 10, 0, false, 0,false);
            culture = FieldProperty.NewInstance("nchar", "ProductModelProductDescription", "Culture","[Culture]", 12, 6, 0, false, "",false);
            modifiedDate = FieldProperty.NewInstance("datetime", "ProductModelProductDescription", "ModifiedDate","[ModifiedDate]", 16, 23, 3, false, null,false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.productModelID;
            yield return this.productDescriptionID;
            yield return this.culture;
            yield return this.modifiedDate;
            
        }
                
    }
}