using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table ProductCategory Field`
    /// </summary>
    [Serializable()]
    public class ProductCategoryTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[ProductCategoryID]</summary>
        protected Int32 _productCategoryID;
        ///<summary>[ProductCategoryID]</summary>
        public Int32 productCategoryID{
            get{return _productCategoryID;}
            set{_productCategoryID = value;}
        }
        ///<summary>[ParentProductCategoryID]</summary>
        protected System.Nullable<Int32> _parentProductCategoryID;
        ///<summary>[ParentProductCategoryID]</summary>
        public System.Nullable<Int32> parentProductCategoryID{
            get{return _parentProductCategoryID;}
            set{_parentProductCategoryID = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public ProductCategoryTableRow() : base()
        {
            this._productCategoryID = 0;
            this._parentProductCategoryID = null;
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "ProductCategoryID"){ this._productCategoryID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "ParentProductCategoryID"){ this._parentProductCategoryID = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "ProductCategoryID") return this._productCategoryID;
            if(name ==  "ParentProductCategoryID") return this._parentProductCategoryID;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            ProductCategoryTableRow clone = new ProductCategoryTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(ProductCategoryTableRow source)
        {
            this.productCategoryID = source.productCategoryID;
            this.parentProductCategoryID = source.parentProductCategoryID;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("ProductCategoryID")){ this._productCategoryID = NumberUtil.Value<Int32>(row["ProductCategoryID"]); }
            if (cols.Contains("ParentProductCategoryID")){ this._parentProductCategoryID = NumberUtil.Value<Int32?>(row["ParentProductCategoryID"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "ProductCategoryID");if (cols.Contains(columnName)){ this._productCategoryID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "ParentProductCategoryID");if (cols.Contains(columnName)){ this._parentProductCategoryID = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._productCategoryID = NumberUtil.Value<Int32>(reader[0]);
            this._parentProductCategoryID = NumberUtil.Value<Int32?>(reader[1]);
            this._modifiedDate = DateUtil.DateValue(reader[2]);
            
            this.IsNew = false;
        }
    }

}