using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table CustomerAddress Field`
    /// </summary>
    [Serializable()]
    public class CustomerAddressTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[CustomerID]</summary>
        protected Int32 _customerID;
        ///<summary>[CustomerID]</summary>
        public Int32 customerID{
            get{return _customerID;}
            set{_customerID = value;}
        }
        ///<summary>[AddressID]</summary>
        protected Int32 _addressID;
        ///<summary>[AddressID]</summary>
        public Int32 addressID{
            get{return _addressID;}
            set{_addressID = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public CustomerAddressTableRow() : base()
        {
            this._customerID = 0;
            this._addressID = 0;
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "CustomerID"){ this._customerID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "AddressID"){ this._addressID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "CustomerID") return this._customerID;
            if(name ==  "AddressID") return this._addressID;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            CustomerAddressTableRow clone = new CustomerAddressTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(CustomerAddressTableRow source)
        {
            this.customerID = source.customerID;
            this.addressID = source.addressID;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("CustomerID")){ this._customerID = NumberUtil.Value<Int32>(row["CustomerID"]); }
            if (cols.Contains("AddressID")){ this._addressID = NumberUtil.Value<Int32>(row["AddressID"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "CustomerID");if (cols.Contains(columnName)){ this._customerID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "AddressID");if (cols.Contains(columnName)){ this._addressID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._customerID = NumberUtil.Value<Int32>(reader[0]);
            this._addressID = NumberUtil.Value<Int32>(reader[1]);
            this._modifiedDate = DateUtil.DateValue(reader[2]);
            
            this.IsNew = false;
        }
    }

}