using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace CFW.Database.Test.AdventureWorks.Models.Base
{
    /// <summary>
    /// table Address Field`
    /// </summary>
    [Serializable()]
    public class AddressTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[AddressID]</summary>
        protected Int32 _addressID;
        ///<summary>[AddressID]</summary>
        public Int32 addressID{
            get{return _addressID;}
            set{_addressID = value;}
        }
        ///<summary>[AddressLine1]</summary>
        protected string _addressLine1;
        ///<summary>[AddressLine1]</summary>
        public string addressLine1{
            get{return _addressLine1;}
            set{_addressLine1 = value;}
        }
        ///<summary>[AddressLine2]</summary>
        protected string _addressLine2;
        ///<summary>[AddressLine2]</summary>
        public string addressLine2{
            get{return _addressLine2;}
            set{_addressLine2 = value;}
        }
        ///<summary>[City]</summary>
        protected string _city;
        ///<summary>[City]</summary>
        public string city{
            get{return _city;}
            set{_city = value;}
        }
        ///<summary>[PostalCode]</summary>
        protected string _postalCode;
        ///<summary>[PostalCode]</summary>
        public string postalCode{
            get{return _postalCode;}
            set{_postalCode = value;}
        }
        ///<summary>[ModifiedDate]</summary>
        protected DateTime? _modifiedDate;
        ///<summary>[ModifiedDate]</summary>
        public DateTime? modifiedDate{
            get{return _modifiedDate;}
            set{_modifiedDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public AddressTableRow() : base()
        {
            this._addressID = 0;
            this._addressLine1 = "";
            this._addressLine2 = "";
            this._city = "";
            this._postalCode = "";
            this._modifiedDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "AddressID"){ this._addressID = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "AddressLine1"){ this._addressLine1 = StringUtil.StringValue( value );return; }
            if(name ==  "AddressLine2"){ this._addressLine2 = StringUtil.StringValue( value );return; }
            if(name ==  "City"){ this._city = StringUtil.StringValue( value );return; }
            if(name ==  "PostalCode"){ this._postalCode = StringUtil.StringValue( value );return; }
            if(name ==  "ModifiedDate"){ this._modifiedDate = DateUtil.DateValue( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "AddressID") return this._addressID;
            if(name ==  "AddressLine1") return this._addressLine1;
            if(name ==  "AddressLine2") return this._addressLine2;
            if(name ==  "City") return this._city;
            if(name ==  "PostalCode") return this._postalCode;
            if(name ==  "ModifiedDate") return this._modifiedDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            AddressTableRow clone = new AddressTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(AddressTableRow source)
        {
            this.addressID = source.addressID;
            this.addressLine1 = source.addressLine1;
            this.addressLine2 = source.addressLine2;
            this.city = source.city;
            this.postalCode = source.postalCode;
            this.modifiedDate = source.modifiedDate;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("AddressID")){ this._addressID = NumberUtil.Value<Int32>(row["AddressID"]); }
            if (cols.Contains("AddressLine1")){ this._addressLine1 = StringUtil.StringValue(row["AddressLine1"]); }
            if (cols.Contains("AddressLine2")){ this._addressLine2 = StringUtil.StringValue(row["AddressLine2"]); }
            if (cols.Contains("City")){ this._city = StringUtil.StringValue(row["City"]); }
            if (cols.Contains("PostalCode")){ this._postalCode = StringUtil.StringValue(row["PostalCode"]); }
            if (cols.Contains("ModifiedDate")){ this._modifiedDate = DateUtil.DateValue(row["ModifiedDate"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "AddressID");if (cols.Contains(columnName)){ this._addressID = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "AddressLine1");if (cols.Contains(columnName)){ this._addressLine1 = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "AddressLine2");if (cols.Contains(columnName)){ this._addressLine2 = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "City");if (cols.Contains(columnName)){ this._city = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PostalCode");if (cols.Contains(columnName)){ this._postalCode = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "ModifiedDate");if (cols.Contains(columnName)){ this._modifiedDate = DateUtil.DateValue(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._addressID = NumberUtil.Value<Int32>(reader[0]);
            this._addressLine1 = StringUtil.StringValue(reader[1]);
            this._addressLine2 = StringUtil.StringValue(reader[2]);
            this._city = StringUtil.StringValue(reader[3]);
            this._postalCode = StringUtil.StringValue(reader[4]);
            this._modifiedDate = DateUtil.DateValue(reader[5]);
            
            this.IsNew = false;
        }
    }

}