using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using CFW.Database.Test.AdventureWorks.Models.Base;

namespace CFW.Database.Test.AdventureWorks.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table Product Field`
    /// </summary>
    public class ProductTableFormAdapter : CFW.Forms.FormAdapter
	{
		private ProductTableRow theEntity;

		///<summary>[ProductID]</summary>
		public FormAdapterElement productID;
		///<summary>[ProductNumber]</summary>
		public FormAdapterElement productNumber;
		///<summary>[Color]</summary>
		public FormAdapterElement color;
		///<summary>[StandardCost]</summary>
		public FormAdapterElement standardCost;
		///<summary>[ListPrice]</summary>
		public FormAdapterElement listPrice;
		///<summary>[Size]</summary>
		public FormAdapterElement size;
		///<summary>[Weight]</summary>
		public FormAdapterElement weight;
		///<summary>[ProductCategoryID]</summary>
		public FormAdapterElement productCategoryID;
		///<summary>[ProductModelID]</summary>
		public FormAdapterElement productModelID;
		///<summary>[SellStartDate]</summary>
		public FormAdapterElement sellStartDate;
		///<summary>[SellEndDate]</summary>
		public FormAdapterElement sellEndDate;
		///<summary>[DiscontinuedDate]</summary>
		public FormAdapterElement discontinuedDate;
		///<summary>[ThumbnailPhotoFileName]</summary>
		public FormAdapterElement thumbnailPhotoFileName;
		///<summary>[ModifiedDate]</summary>
		public FormAdapterElement modifiedDate;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.productID != null) this.productID.Render();
			if(this.productNumber != null) this.productNumber.Render();
			if(this.color != null) this.color.Render();
			if(this.standardCost != null) this.standardCost.Render();
			if(this.listPrice != null) this.listPrice.Render();
			if(this.size != null) this.size.Render();
			if(this.weight != null) this.weight.Render();
			if(this.productCategoryID != null) this.productCategoryID.Render();
			if(this.productModelID != null) this.productModelID.Render();
			if(this.sellStartDate != null) this.sellStartDate.Render();
			if(this.sellEndDate != null) this.sellEndDate.Render();
			if(this.discontinuedDate != null) this.discontinuedDate.Render();
			if(this.thumbnailPhotoFileName != null) this.thumbnailPhotoFileName.Render();
			if(this.modifiedDate != null) this.modifiedDate.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (ProductTableRow)entity;
			if(this.productID != null) this.productID.SetValue(this.theEntity.productID);
			if(this.productNumber != null) this.productNumber.SetValue(this.theEntity.productNumber);
			if(this.color != null) this.color.SetValue(this.theEntity.color);
			if(this.standardCost != null) this.standardCost.SetValue(this.theEntity.standardCost);
			if(this.listPrice != null) this.listPrice.SetValue(this.theEntity.listPrice);
			if(this.size != null) this.size.SetValue(this.theEntity.size);
			if(this.weight != null) this.weight.SetValue(this.theEntity.weight);
			if(this.productCategoryID != null) this.productCategoryID.SetValue(this.theEntity.productCategoryID);
			if(this.productModelID != null) this.productModelID.SetValue(this.theEntity.productModelID);
			if(this.sellStartDate != null) this.sellStartDate.SetValue(this.theEntity.sellStartDate);
			if(this.sellEndDate != null) this.sellEndDate.SetValue(this.theEntity.sellEndDate);
			if(this.discontinuedDate != null) this.discontinuedDate.SetValue(this.theEntity.discontinuedDate);
			if(this.thumbnailPhotoFileName != null) this.thumbnailPhotoFileName.SetValue(this.theEntity.thumbnailPhotoFileName);
			if(this.modifiedDate != null) this.modifiedDate.SetValue(this.theEntity.modifiedDate);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.productID != null) this.theEntity.productID = NumberUtil.Value<Int32>(this.productID.GetValue());
			if(this.productNumber != null) this.theEntity.productNumber = StringUtil.StringValue(this.productNumber.GetValue());
			if(this.color != null) this.theEntity.color = StringUtil.StringValue(this.color.GetValue());
			if(this.standardCost != null) this.theEntity.standardCost = NumberUtil.Value<Decimal>(this.standardCost.GetValue());
			if(this.listPrice != null) this.theEntity.listPrice = NumberUtil.Value<Decimal>(this.listPrice.GetValue());
			if(this.size != null) this.theEntity.size = StringUtil.StringValue(this.size.GetValue());
			if(this.weight != null) this.theEntity.weight = NumberUtil.Value<Decimal?>(this.weight.GetValue());
			if(this.productCategoryID != null) this.theEntity.productCategoryID = NumberUtil.Value<Int32?>(this.productCategoryID.GetValue());
			if(this.productModelID != null) this.theEntity.productModelID = NumberUtil.Value<Int32?>(this.productModelID.GetValue());
			if(this.sellStartDate != null) this.theEntity.sellStartDate = DateUtil.DateValue(this.sellStartDate.GetValue());
			if(this.sellEndDate != null) this.theEntity.sellEndDate = DateUtil.DateValue(this.sellEndDate.GetValue());
			if(this.discontinuedDate != null) this.theEntity.discontinuedDate = DateUtil.DateValue(this.discontinuedDate.GetValue());
			if(this.thumbnailPhotoFileName != null) this.theEntity.thumbnailPhotoFileName = StringUtil.StringValue(this.thumbnailPhotoFileName.GetValue());
			if(this.modifiedDate != null) this.theEntity.modifiedDate = DateUtil.DateValue(this.modifiedDate.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.productID != null) this.productID.UpdateField();
			if(this.productNumber != null) this.productNumber.UpdateField();
			if(this.color != null) this.color.UpdateField();
			if(this.standardCost != null) this.standardCost.UpdateField();
			if(this.listPrice != null) this.listPrice.UpdateField();
			if(this.size != null) this.size.UpdateField();
			if(this.weight != null) this.weight.UpdateField();
			if(this.productCategoryID != null) this.productCategoryID.UpdateField();
			if(this.productModelID != null) this.productModelID.UpdateField();
			if(this.sellStartDate != null) this.sellStartDate.UpdateField();
			if(this.sellEndDate != null) this.sellEndDate.UpdateField();
			if(this.discontinuedDate != null) this.discontinuedDate.UpdateField();
			if(this.thumbnailPhotoFileName != null) this.thumbnailPhotoFileName.UpdateField();
			if(this.modifiedDate != null) this.modifiedDate.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.productID != null){
			    if(!this.productID.Validate()){
				    valid = false;
				    this.messages.Add(this.productID.ErrorMessage);
			    }
			}
			
			if(this.productNumber != null){
			    if(!this.productNumber.Validate()){
				    valid = false;
				    this.messages.Add(this.productNumber.ErrorMessage);
			    }
			}
			
			if(this.color != null){
			    if(!this.color.Validate()){
				    valid = false;
				    this.messages.Add(this.color.ErrorMessage);
			    }
			}
			
			if(this.standardCost != null){
			    if(!this.standardCost.Validate()){
				    valid = false;
				    this.messages.Add(this.standardCost.ErrorMessage);
			    }
			}
			
			if(this.listPrice != null){
			    if(!this.listPrice.Validate()){
				    valid = false;
				    this.messages.Add(this.listPrice.ErrorMessage);
			    }
			}
			
			if(this.size != null){
			    if(!this.size.Validate()){
				    valid = false;
				    this.messages.Add(this.size.ErrorMessage);
			    }
			}
			
			if(this.weight != null){
			    if(!this.weight.Validate()){
				    valid = false;
				    this.messages.Add(this.weight.ErrorMessage);
			    }
			}
			
			if(this.productCategoryID != null){
			    if(!this.productCategoryID.Validate()){
				    valid = false;
				    this.messages.Add(this.productCategoryID.ErrorMessage);
			    }
			}
			
			if(this.productModelID != null){
			    if(!this.productModelID.Validate()){
				    valid = false;
				    this.messages.Add(this.productModelID.ErrorMessage);
			    }
			}
			
			if(this.sellStartDate != null){
			    if(!this.sellStartDate.Validate()){
				    valid = false;
				    this.messages.Add(this.sellStartDate.ErrorMessage);
			    }
			}
			
			if(this.sellEndDate != null){
			    if(!this.sellEndDate.Validate()){
				    valid = false;
				    this.messages.Add(this.sellEndDate.ErrorMessage);
			    }
			}
			
			if(this.discontinuedDate != null){
			    if(!this.discontinuedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.discontinuedDate.ErrorMessage);
			    }
			}
			
			if(this.thumbnailPhotoFileName != null){
			    if(!this.thumbnailPhotoFileName.Validate()){
				    valid = false;
				    this.messages.Add(this.thumbnailPhotoFileName.ErrorMessage);
			    }
			}
			
			if(this.modifiedDate != null){
			    if(!this.modifiedDate.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedDate.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private ProductFormAdapter formAdapter;
    //     private ProductProperty property;
    //     private ProductEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new ProductFormAdapter();

	
    formAdapter.productID= new TextBoxAdapterElement(
        productID,
        new CFW.Forms.Filters.StringFilter(property.productID),
        CFW.Validators.FieldValidator.GetInstance(property.productID)
    );
	
    formAdapter.productNumber= new TextBoxAdapterElement(
        productNumber,
        new CFW.Forms.Filters.StringFilter(property.productNumber),
        CFW.Validators.FieldValidator.GetInstance(property.productNumber)
    );
	
    formAdapter.color= new TextBoxAdapterElement(
        color,
        new CFW.Forms.Filters.StringFilter(property.color),
        CFW.Validators.FieldValidator.GetInstance(property.color)
    );
	
    formAdapter.standardCost= new TextBoxAdapterElement(
        standardCost,
        new CFW.Forms.Filters.StringFilter(property.standardCost),
        CFW.Validators.FieldValidator.GetInstance(property.standardCost)
    );
	
    formAdapter.listPrice= new TextBoxAdapterElement(
        listPrice,
        new CFW.Forms.Filters.StringFilter(property.listPrice),
        CFW.Validators.FieldValidator.GetInstance(property.listPrice)
    );
	
    formAdapter.size= new TextBoxAdapterElement(
        size,
        new CFW.Forms.Filters.StringFilter(property.size),
        CFW.Validators.FieldValidator.GetInstance(property.size)
    );
	
    formAdapter.weight= new TextBoxAdapterElement(
        weight,
        new CFW.Forms.Filters.StringFilter(property.weight),
        CFW.Validators.FieldValidator.GetInstance(property.weight)
    );
	
    formAdapter.productCategoryID= new TextBoxAdapterElement(
        productCategoryID,
        new CFW.Forms.Filters.StringFilter(property.productCategoryID),
        CFW.Validators.FieldValidator.GetInstance(property.productCategoryID)
    );
	
    formAdapter.productModelID= new TextBoxAdapterElement(
        productModelID,
        new CFW.Forms.Filters.StringFilter(property.productModelID),
        CFW.Validators.FieldValidator.GetInstance(property.productModelID)
    );
	
    formAdapter.sellStartDate= new TextBoxAdapterElement(
        sellStartDate,
        new CFW.Forms.Filters.StringFilter(property.sellStartDate),
        CFW.Validators.FieldValidator.GetInstance(property.sellStartDate)
    );
	
    formAdapter.sellEndDate= new TextBoxAdapterElement(
        sellEndDate,
        new CFW.Forms.Filters.StringFilter(property.sellEndDate),
        CFW.Validators.FieldValidator.GetInstance(property.sellEndDate)
    );
	
    formAdapter.discontinuedDate= new TextBoxAdapterElement(
        discontinuedDate,
        new CFW.Forms.Filters.StringFilter(property.discontinuedDate),
        CFW.Validators.FieldValidator.GetInstance(property.discontinuedDate)
    );
	
    formAdapter.thumbnailPhotoFileName= new TextBoxAdapterElement(
        thumbnailPhotoFileName,
        new CFW.Forms.Filters.StringFilter(property.thumbnailPhotoFileName),
        CFW.Validators.FieldValidator.GetInstance(property.thumbnailPhotoFileName)
    );
	
    formAdapter.modifiedDate= new TextBoxAdapterElement(
        modifiedDate,
        new CFW.Forms.Filters.StringFilter(property.modifiedDate),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedDate)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}