using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Serializer
{
    [TestFixture]
    public class ObjectSerializerTest
    {
        [NUnit.Framework.Test]
        public void XmlSerialize()
        {
            CFW.Serializer.Serializer serializer = new CFW.Serializer.ObjectSerializer(typeof(TestObject),new CFW.Serializer.Drivers.XMLSerializeDriver());

            //܂VACYĂ݂
            TestObject obj = new TestObject();
            obj.IntField = 1001;
            obj.ShortField = 101;
            obj.DateTimeField = new DateTime(1975,12,31);
            obj.DecimalField = 1234.56M;
            obj.StringField = "abcdefghij";

            System.IO.StringWriter writer = new System.IO.StringWriter();
            serializer.Serialize(writer,obj);

            string result = writer.ToString();
            writer.Close();

            Assert.IsNotEmpty(result);
            //TODO: e`FbN

            //fVACYāÃIuWFNgƓ悤ȂOK
           
            System.IO.StringReader reader = new System.IO.StringReader(result);
            TestObject obj2 = (TestObject)serializer.Deserialize(reader);
            Assert.IsNotNull(obj2);

            Assert.AreEqual(obj.DateTimeField,obj2.DateTimeField);
            Assert.AreEqual(obj.DecimalField,obj2.DecimalField);
            Assert.AreEqual(obj.IntField,obj2.IntField);
            Assert.AreEqual(obj.ShortField,obj2.ShortField);
            Assert.AreEqual(obj.StringField,obj2.StringField);




        }
        [NUnit.Framework.Test]
        public void JSONSerialize()
        {
            CFW.Serializer.Serializer serializer = new CFW.Serializer.ObjectSerializer(typeof(TestObject), new CFW.Serializer.Drivers.JSONSerializeDriver());

            //܂VACYĂ݂
            TestObject obj = new TestObject();
            obj.IntField = 1001;
            obj.ShortField = 101;
            obj.DateTimeField = new DateTime(1975, 12, 31);
            obj.DecimalField = 1234.56M;
            obj.StringField = "abcdefghij";

            System.IO.StringWriter writer = new System.IO.StringWriter();
            serializer.Serialize(writer, obj);

            string result = writer.ToString();
            writer.Close();

            Assert.IsNotEmpty(result);
            //TODO: e`FbN

            //fVACYāÃIuWFNgƓ悤ȂOK

            System.IO.StringReader reader = new System.IO.StringReader(result);
            TestObject obj2 = (TestObject)serializer.Deserialize(reader);
            Assert.IsNotNull(obj2);

            Assert.AreEqual(obj.DateTimeField, obj2.DateTimeField);
            Assert.AreEqual(obj.DecimalField, obj2.DecimalField);
            Assert.AreEqual(obj.IntField, obj2.IntField);
            Assert.AreEqual(obj.ShortField, obj2.ShortField);
            Assert.AreEqual(obj.StringField, obj2.StringField);




        }
    }
}
