using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test
{
    [TestFixture]
    public class NumberUtilTest
    {
        [NUnit.Framework.Test]
        public void RoundDecimal()
        {
            decimal a = 123.499M;
            decimal result = CFW.Util.NumberUtil.Round(a, 0);
            Assert.AreEqual(123M, result);

            a = 123.5M;
            result = CFW.Util.NumberUtil.Round(a, 0);
            Assert.AreEqual(124M, result);

            a = 123.9999M;
            result = CFW.Util.NumberUtil.Round(a, 0);
            Assert.AreEqual(124M, result);

            a = 123.9999M;
            result = CFW.Util.NumberUtil.Round(a, 2);
            Assert.AreEqual(124.00M, result);

            a = 123.4449999M;
            result = CFW.Util.NumberUtil.Round(a, 2);
            Assert.AreEqual(123.44M, result);

            a = 123.445111M;
            result = CFW.Util.NumberUtil.Round(a, 2);
            Assert.AreEqual(123.45M, result);

            a = 1234567499.445111M;
            result = CFW.Util.NumberUtil.Round(a, -3);
            Assert.AreEqual(1234567000M, result);

            a = 1234567500.445111M;
            result = CFW.Util.NumberUtil.Round(a, -3);
            Assert.AreEqual(1234568000M, result);
        }
        [NUnit.Framework.Test]
        public void RoundDecimal2()
        {
            decimal a = 123.05M;
            decimal result = CFW.Util.NumberUtil.Round(a, 1);
            Assert.AreEqual(123.1M, result);

            a = 123.15M;
            result = CFW.Util.NumberUtil.Round(a, 1);
            Assert.AreEqual(123.2M, result);
        }
        [NUnit.Framework.Test]
        public void RoundDecimal3()
        {
            decimal a = 123.25M;
            decimal result = CFW.Util.NumberUtil.Round(a, 1);
            Assert.AreEqual(123.3M, result);
        }
        [NUnit.Framework.Test]
        public void RoundUpDecimal()
        {
            decimal a = 123.499M;
            decimal result = CFW.Util.NumberUtil.RoundUp(a, 0);
            Assert.AreEqual(124M, result);

            a = 123.5M;
            result = CFW.Util.NumberUtil.RoundUp(a, 0);
            Assert.AreEqual(124M, result);

            a = 123.9999M;
            result = CFW.Util.NumberUtil.RoundUp(a, 0);
            Assert.AreEqual(124M, result);

            a = 123.9999M;
            result = CFW.Util.NumberUtil.RoundUp(a, 2);
            Assert.AreEqual(124.00M, result);

            a = 123.4449999M;
            result = CFW.Util.NumberUtil.RoundUp(a, 2);
            Assert.AreEqual(123.45M, result);

            a = 123.445111M;
            result = CFW.Util.NumberUtil.RoundUp(a, 2);
            Assert.AreEqual(123.45M, result);

            a = 1234567499.445111M;
            result = CFW.Util.NumberUtil.RoundUp(a, -3);
            Assert.AreEqual(1234568000M, result);

            a = 1234567500.445111M;
            result = CFW.Util.NumberUtil.RoundUp(a, -3);
            Assert.AreEqual(1234568000M, result);
        }
        [NUnit.Framework.Test]
        public void RoundDownDecimal()
        {
            decimal a = 123.499M;
            decimal result = CFW.Util.NumberUtil.RoundDown(a, 0);
            Assert.AreEqual(123M, result);

            a = 123.5M;
            result = CFW.Util.NumberUtil.RoundDown(a, 0);
            Assert.AreEqual(123M, result);

            a = 123.9999M;
            result = CFW.Util.NumberUtil.RoundDown(a, 0);
            Assert.AreEqual(123M, result);

            a = 123.9999M;
            result = CFW.Util.NumberUtil.RoundDown(a, 2);
            Assert.AreEqual(123.99M, result);

            a = 123.4449999M;
            result = CFW.Util.NumberUtil.RoundDown(a, 2);
            Assert.AreEqual(123.44M, result);

            a = 123.445111M;
            result = CFW.Util.NumberUtil.RoundDown(a, 2);
            Assert.AreEqual(123.44M, result);

            a = 1234567499.445111M;
            result = CFW.Util.NumberUtil.RoundDown(a, -3);
            Assert.AreEqual(1234567000M, result);

            a = 1234567500.445111M;
            result = CFW.Util.NumberUtil.RoundDown(a, -3);
            Assert.AreEqual(1234567000M, result);
        }

        public void RoundDouble()
        {
            double a = 123.499D;
            double result = CFW.Util.NumberUtil.Round(a, 0);
            Assert.AreEqual(123D, result);

            a = 123.5D;
            result = CFW.Util.NumberUtil.Round(a, 0);
            Assert.AreEqual(124D, result);

            a = 123.9999D;
            result = CFW.Util.NumberUtil.Round(a, 0);
            Assert.AreEqual(124D, result);

            a = 123.9999D;
            result = CFW.Util.NumberUtil.Round(a, 2);
            Assert.AreEqual(124.00D, result);

            a = 123.4449999D;
            result = CFW.Util.NumberUtil.Round(a, 2);
            Assert.AreEqual(123.44D, result);

            a = 123.445111D;
            result = CFW.Util.NumberUtil.Round(a, 2);
            Assert.AreEqual(123.45D, result);

            a = 1234567499.445111D;
            result = CFW.Util.NumberUtil.Round(a, -3);
            Assert.AreEqual(1234567000D, result);

            a = 1234567500.445111D;
            result = CFW.Util.NumberUtil.Round(a, -3);
            Assert.AreEqual(1234568000D, result);
        }
        [NUnit.Framework.Test]
        public void RoundUpDouble()
        {
            double a = 123.499D;
            double result = CFW.Util.NumberUtil.RoundUp(a, 0);
            Assert.AreEqual(124D, result);

            a = 123.5D;
            result = CFW.Util.NumberUtil.RoundUp(a, 0);
            Assert.AreEqual(124D, result);

            a = 123.9999D;
            result = CFW.Util.NumberUtil.RoundUp(a, 0);
            Assert.AreEqual(124D, result);

            a = 123.9999D;
            result = CFW.Util.NumberUtil.RoundUp(a, 2);
            Assert.AreEqual(124.00D, result);

            a = 123.4449999D;
            result = CFW.Util.NumberUtil.RoundUp(a, 2);
            Assert.AreEqual(123.45D, result);

            a = 123.445111D;
            result = CFW.Util.NumberUtil.RoundUp(a, 2);
            Assert.AreEqual(123.45D, result);

            a = 1234567499.445111D;
            result = CFW.Util.NumberUtil.RoundUp(a, -3);
            Assert.AreEqual(1234568000D, result);

            a = 1234567500.445111D;
            result = CFW.Util.NumberUtil.RoundUp(a, -3);
            Assert.AreEqual(1234568000D, result);
        }
        [NUnit.Framework.Test]
        public void RoundDownDouble()
        {
            double a = 123.499D;
            double result = CFW.Util.NumberUtil.RoundDown(a, 0);
            Assert.AreEqual(123D, result);

            a = 123.5D;
            result = CFW.Util.NumberUtil.RoundDown(a, 0);
            Assert.AreEqual(123D, result);

            a = 123.9999D;
            result = CFW.Util.NumberUtil.RoundDown(a, 0);
            Assert.AreEqual(123D, result);

            a = 123.9999D;
            result = CFW.Util.NumberUtil.RoundDown(a, 2);
            Assert.AreEqual(123.99D, result);

            a = 123.4449999D;
            result = CFW.Util.NumberUtil.RoundDown(a, 2);
            Assert.AreEqual(123.44D, result);

            a = 123.445111D;
            result = CFW.Util.NumberUtil.RoundDown(a, 2);
            Assert.AreEqual(123.44D, result);

            a = 1234567499.445111D;
            result = CFW.Util.NumberUtil.RoundDown(a, -3);
            Assert.AreEqual(1234567000D, result);

            a = 1234567500.445111D;
            result = CFW.Util.NumberUtil.RoundDown(a, -3);
            Assert.AreEqual(1234567000D, result);
        }
        [NUnit.Framework.Test]
        public void FormatCurrencyDecimal()
        {
            string result = CFW.Util.NumberUtil.FormatCurrency(123456M);
            Assert.AreEqual("\\123,456", result);

            result = CFW.Util.NumberUtil.FormatCurrency(123456.789M);
            Assert.AreEqual("\\123,457", result);

            result = CFW.Util.NumberUtil.FormatCurrency(123456.789M);
            Assert.AreEqual("\\123,457", result);

            result = CFW.Util.NumberUtil.FormatCurrency(123456.789M,5);
            Assert.AreEqual("\\123,456.78900", result);

            result = CFW.Util.NumberUtil.FormatCurrency(123456.789M, 2);
            Assert.AreEqual("\\123,456.79", result);
        }
        [NUnit.Framework.Test]
        public void FormatCurrencyInt()
        {
            int a = 123456;
            string result = CFW.Util.NumberUtil.FormatCurrency(a);
            Assert.AreEqual("\\123,456", result);

            a = 0;
            result = CFW.Util.NumberUtil.FormatCurrency(a);
            Assert.AreEqual("\\0", result);
        }

        [NUnit.Framework.Test]
        public void ParseBool()
        {
            string input = "1";
            bool b = CFW.Util.NumberUtil.ParseBool(input);
            Assert.IsTrue(b);

            input = "0";
            b = CFW.Util.NumberUtil.ParseBool(input);
            Assert.IsFalse(b);

            input = "yes";
            b = CFW.Util.NumberUtil.ParseBool(input);
            Assert.IsTrue(b);


            input = "no";
            b = CFW.Util.NumberUtil.ParseBool(input);
            Assert.IsFalse(b);

            input = "Y";
            b = CFW.Util.NumberUtil.ParseBool(input);
            Assert.IsTrue(b);

            input = "N";
            b = CFW.Util.NumberUtil.ParseBool(input);
            Assert.IsFalse(b);


            input = "";
            b = CFW.Util.NumberUtil.ParseBool(input);
            Assert.IsFalse(b);
        }
        [NUnit.Framework.Test]
        public void Parse()
        {
            string input = "1234567890";
            byte byteValue = CFW.Util.NumberUtil.Parse<byte>(input);
            Assert.AreEqual(0, byteValue);

            input = "123";
            byteValue = CFW.Util.NumberUtil.Parse<byte>(input);
            Assert.AreEqual(123, byteValue);

            input = "1234567890";
            short shortValue = CFW.Util.NumberUtil.Parse<short>(input);
            Assert.AreEqual(0, shortValue);

            input = "12345";
            shortValue = CFW.Util.NumberUtil.Parse<short>(input);
            Assert.AreEqual(12345, shortValue);

            input = "123.45";
            shortValue = CFW.Util.NumberUtil.Parse<short>(input);
            Assert.AreEqual(0, shortValue);

            input = "12345678901";
            int intValue = CFW.Util.NumberUtil.Parse<int>(input);
            Assert.AreEqual(0, shortValue);

            input = "1234567890";
            intValue = CFW.Util.NumberUtil.Parse<int>(input);
            Assert.AreEqual(1234567890, intValue);

            input = "1234567890.12345";
            decimal decimalValue = CFW.Util.NumberUtil.Parse<decimal>(input);
            Assert.AreEqual(1234567890.12345, decimalValue);

            input = "1234567890";
            decimalValue = CFW.Util.NumberUtil.Parse<decimal>(input);
            Assert.AreEqual(1234567890, decimalValue);
        }
    }
}
