using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using CFW.FieldProperties;
namespace CFW.Common.Test.FieldPropertis
{
    [NUnit.Framework.TestFixture]
    public class IntFieldPropertyTest
    {
        [NUnit.Framework.Test]
        public void createTest1()
        {
            FieldProperty p = FieldProperty.create("int");
            Assert.IsInstanceOfType(typeof( IntFieldProperty ) , p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0,p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest2()
        {
            FieldProperty p = FieldProperty.create("int","testtable","column1","1");
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create("int",5);
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest4()
        {
            //precision,scalew肵precision̂ݍ̗pB͍őlAŏlɊւ
            FieldProperty p = FieldProperty.create("int", 7,2);
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(7, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest5()
        {
            //full spec
            FieldProperty p = FieldProperty.create("int","table1","column1","1",0,0,0,false,1,true);
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual(1, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType1()
        {
            FieldProperty p = FieldProperty.create(typeof(int));
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType2()
        {
            FieldProperty p = FieldProperty.create(typeof(int), "testtable", "column1", "1");
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create(typeof(int), 5);
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType4()
        {
            //precision,scalew肵precision̂ݍ̗pB͍őlAŏlɊւ
            FieldProperty p = FieldProperty.create(typeof(int), 7, 2);
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(7, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType5()
        {
            //full spec
            FieldProperty p = FieldProperty.create(typeof(int), "table1", "column1", "1", 0, 0, 0, false, 1, true);
            Assert.IsInstanceOfType(typeof(IntFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(int), p.FieldType);
            Assert.AreEqual(4, p.Length);
            Assert.AreEqual(10, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual(1, p.DefaultValue);

        }
    }
}
