using System;
using System.Collections.Generic;
using System.Text;
using CFW.FieldProperties;
using NUnit.Framework;

namespace CFW.Common.Test.FieldProperties
{
    [NUnit.Framework.TestFixture]
    public class DoubleFieldPropertyTest
    {
        [NUnit.Framework.Test]
        public void createTest1()
        {
            FieldProperty p = FieldProperty.create("float");
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest2()
        {
            FieldProperty p = FieldProperty.create("float", "testtable", "column1", "1");
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create("float", 5);
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(5, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest4()
        {
            FieldProperty p = FieldProperty.create("float", 3, 2);
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(3, p.Precision);
            Assert.AreEqual(2, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createTest5()
        {
            //full spec
            FieldProperty p = FieldProperty.create("float", "table1", "column1", "1", 8, 15, 0, false, 1, true);
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual(1, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType1()
        {
            FieldProperty p = FieldProperty.create(typeof(double));
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType2()
        {
            FieldProperty p = FieldProperty.create(typeof(double), "testtable", "column1", "1");
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("testtable", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType3()
        {
            //lengthw肵ĂӖ͖B
            FieldProperty p = FieldProperty.create(typeof(double), 5);
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(5, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType4()
        {
            //precision,scalew肵precision̂ݍ̗pB͍őlAŏlɊւ
            FieldProperty p = FieldProperty.create(typeof(double), 4, 2);
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("", p.TableName);
            Assert.AreEqual("", p.FieldName);
            Assert.AreEqual("", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(4, p.Precision);
            Assert.AreEqual(2, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsFalse(p.IsPrimaryKey);
            Assert.AreEqual(0, p.DefaultValue);

        }
        [NUnit.Framework.Test]
        public void createByType5()
        {
            //full spec
            FieldProperty p = FieldProperty.create(typeof(double), "table1", "column1", "1", 8, 15, 0, false, 1, true);
            Assert.IsInstanceOfType(typeof(DoubleFieldProperty), p);

            Assert.IsNotNull(p);
            Assert.AreEqual("table1", p.TableName);
            Assert.AreEqual("column1", p.FieldName);
            Assert.AreEqual("1", p.DisplayName);
            Assert.AreEqual(typeof(double), p.FieldType);
            Assert.AreEqual(8, p.Length);
            Assert.AreEqual(15, p.Precision);
            Assert.AreEqual(0, p.Scale);

            Assert.IsFalse(p.IsNullable);
            Assert.IsTrue(p.IsPrimaryKey);
            Assert.AreEqual(1, p.DefaultValue);

        }
    }
}
