using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test
{
    [TestFixture]
    public class DateUtilTest
    {
        [NUnit.Framework.Test(Description="ʏ̓t")]
        public void ToDateTime()
        {
            DateTime d = new DateTime(1987, 2, 3, 12, 34, 56);

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime),result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(1987,resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(56, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = "DBNULL")]
        public void ToDateTime2()
        {
            object d = DBNull.Value;

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsNull(result);

        }
        [NUnit.Framework.Test(Description = "tobjectn")]
        public void ToDateTime3()
        {
            object d = new DateTime(1987, 2, 3, 12, 34, 56);

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(1987, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(56, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " Nb ؂")]
        public void ToDateTime4()
        {
            string d = "1987/2/3 12:34:56";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(1987, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(56, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N ؂")]
        public void ToDateTime5()
        {
            string d = "1987/2/3 12:34";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(1987, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N ؂")]
        public void ToDateTime6()
        {
            string d = "1987/2/3";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(1987, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " Nb ؂Ȃ")]
        public void ToDateTime7()
        {
            string d = "20010203123456";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(56, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N ؂Ȃ")]
        public void ToDateTime8()
        {
            string d = "200102031234";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N ؂Ȃ")]
        public void ToDateTime9()
        {
            string d = "20010203";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }

        [NUnit.Framework.Test(Description = " Nb ؂ ϊłȂ")]
        public void ToDateTime10()
        {
            string d = "1987/2/3 12:34:66";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsNull(result);

        }
        [NUnit.Framework.Test(Description = " N ؂")]
        public void ToDateTime11()
        {
            string d = "1987/2/31 12:34";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsNull(result);

        }
        [NUnit.Framework.Test(Description = " N ؂")]
        public void ToDateTime12()
        {
            string d = "1987/2/301";

            object result = CFW.Util.DateUtil.DateValue(d);
            Assert.IsNull(result);

        }

        [NUnit.Framework.Test(Description = " N b ؂Ȃ")]
        public void ParseLongDateTime()
        {
            string d = "20010203";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ")]
        public void ParseLongDateTime2()
        {
            string d = "200102031234";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ")]
        public void ParseLongDateTime3()
        {
            string d = "20010203123456";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(56, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂")]
        public void ParseLongDateTime4()
        {
            string d = "2001/2/3";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂")]
        public void ParseLongDateTime5()
        {
            string d = "2001/2/3 12:34";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂")]
        public void ParseLongDateTime6()
        {
            string d = "2001/2/3 12:34:56";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(56, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ G[")]
        public void ParseLongDateTime7()
        {
            string d = "20010231";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsNull(result);
        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ G[")]
        public void ParseLongDateTime8()
        {
            string d = "200102283456";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsNull(result);
        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ G[")]
        public void ParseLongDateTime9()
        {
            string d = "20010228123461";

            object result = CFW.Util.DateUtil.ParseLongDateTime(d);
            Assert.IsNull(result);
        }

        [NUnit.Framework.Test(Description = " N b ؂Ȃ")]
        public void ParseSmallDateTime()
        {
            string d = "20010203";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ")]
        public void ParseSmallDateTime2()
        {
            string d = "200102031234";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ")]
        public void ParseSmallDateTime3()
        {
            string d = "20010203123456";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂")]
        public void ParseSmallDateTime4()
        {
            string d = "2001/2/3";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂")]
        public void ParseSmallDateTime5()
        {
            string d = "2001/2/3 12:34";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂")]
        public void ParseSmallDateTime6()
        {
            string d = "2001/2/3 12:34:56";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(2, resultDate.Month);
            Assert.AreEqual(3, resultDate.Day);
            Assert.AreEqual(12, resultDate.Hour);
            Assert.AreEqual(34, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);

        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ G[")]
        public void ParseSmallDateTime7()
        {
            string d = "20010231";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsNull(result);
        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ G[")]
        public void ParseSmallDateTime8()
        {
            string d = "200102283456";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsNull(result);
        }
        [NUnit.Framework.Test(Description = " N b ؂Ȃ G[")]
        public void ParseSmallDateTime9()
        {
            string d = "20010228123461";

            object result = CFW.Util.DateUtil.ParseSmallDateTime(d);
            Assert.IsNull(result);
        }

        [NUnit.Framework.Test(Description = "")]
        public void ParseDayMonthAbbr()
        {
            string d = "02APR";

            object result = CFW.Util.DateUtil.ParseDayMonthAbbr(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2011, resultDate.Year);
            Assert.AreEqual(4, resultDate.Month);
            Assert.AreEqual(2, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);
        }
        [NUnit.Framework.Test(Description = "")]
        public void ParseDayMonthAbbr2()
        {
            string d = "16MAY";

            object result = CFW.Util.DateUtil.ParseDayMonthAbbr(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            //Assert.AreEqual(2010, resultDate.Year); //Ԃ̖
            Assert.AreEqual(5, resultDate.Month);
            Assert.AreEqual(16, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);
        }
        [NUnit.Framework.Test(Description = "")]
        public void ParseDayMonthAbbr3()
        {
            DateTime now = DateTime.Now.AddDays(-3);
            string d = now.ToString("ddMMM",Util.Util.USCulture().DateTimeFormat);

            object result = CFW.Util.DateUtil.ParseDayMonthAbbr(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(now.Year, resultDate.Year);
            Assert.AreEqual(now.Month, resultDate.Month);
            Assert.AreEqual(now.Day, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);
        }

        [NUnit.Framework.Test(Description = "N US")]
        public void ParseDayMonthYearAbbr()
        {
            string d = "20MAY2001";

            object result = CFW.Util.DateUtil.ParseDayMonthYearAbbr(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(2001, resultDate.Year);
            Assert.AreEqual(5, resultDate.Month);
            Assert.AreEqual(20, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);
        }
        [NUnit.Framework.Test(Description = "N")]
        public void ParseDayMonthYearShort()
        {
            string d = "31/12/99";

            object result = CFW.Util.DateUtil.ParseDayMonthYearShort(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            DateTime resultDate = (DateTime)result;
            Assert.AreEqual(1999, resultDate.Year);
            Assert.AreEqual(12, resultDate.Month);
            Assert.AreEqual(31, resultDate.Day);
            Assert.AreEqual(0, resultDate.Hour);
            Assert.AreEqual(0, resultDate.Minute);
            Assert.AreEqual(0, resultDate.Second);
        }
        [NUnit.Framework.Test(Description = "ftHgӂ܂")]
        public void Format()
        {
            DateTime d = new DateTime(2001,2,3);

            string result = CFW.Util.DateUtil.Format(d);
            Assert.AreEqual("2001/02/03 0:00:00", result);
        }
        [NUnit.Framework.Test(Description = "tH[}bgw")]
        public void Format2()
        {
            DateTime d = new DateTime(2001, 2, 3);

            string result = CFW.Util.DateUtil.Format(d,"yyyy/M/d");
            Assert.AreEqual("2001/2/3", result);
        }
        [NUnit.Framework.Test(Description = "J`w")]
        public void Format3()
        {
            DateTime d = new DateTime(2001, 2, 3);

            string result = CFW.Util.DateUtil.Format(d, "dd,MMM",CFW.Util.Util.USCulture());
            Assert.AreEqual("03,Feb", result);
        }
        [NUnit.Framework.Test(Description = "t̂")]
        public void FormatLongDate()
        {
            DateTime d = new DateTime(2001, 2, 3);

            string result = CFW.Util.DateUtil.FormatLongDate(d);
            Assert.AreEqual("2001/02/03", result);
        }
        [NUnit.Framework.Test(Description = "t̂")]
        public void FormatLongDateNoDelimiter()
        {
            DateTime d = new DateTime(2001, 2, 3);

            string result = CFW.Util.DateUtil.FormatLongDateNoDelimiter(d);
            Assert.AreEqual("20010203", result);
        }
        [NUnit.Framework.Test(Description = "t")]
        public void FormatLongDateTime()
        {
            DateTime d = new DateTime(2001, 2, 3,12,34,56);

            string result = CFW.Util.DateUtil.FormatLongDateTime(d);
            Assert.AreEqual("2001/02/03 12:34:56", result);
        }
        [NUnit.Framework.Test(Description = "t")]
        public void FormatLongDateTimeNoDelimiter()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);

            string result = CFW.Util.DateUtil.FormatLongDateTimeNoDelimiter(d);
            Assert.AreEqual("20010203123456", result);
        }
        [NUnit.Framework.Test(Description = "t̂")]
        public void FormatSmallDateTime()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);

            string result = CFW.Util.DateUtil.FormatSmallDateTime(d);
            Assert.AreEqual("2001/02/03 12:34", result);
        }
        [NUnit.Framework.Test(Description = "t̂")]
        public void FormatSmallDateTimeNoDelimiter()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);

            string result = CFW.Util.DateUtil.FormatSmallDateTimeNoDelimiter(d);
            Assert.AreEqual("200102031234", result);
        }
        [NUnit.Framework.Test(Description = "  N")]
        public void FormatDayMonthYearAbbr()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);

            string result = CFW.Util.DateUtil.FormatDayMonthYearAbbr(d);
            Assert.AreEqual("03FEB2001", result);
        }
        [NUnit.Framework.Test(Description = " ")]
        public void FormatDayMonthAbbr()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);

            string result = CFW.Util.DateUtil.FormatDayMonthAbbr(d);
            Assert.AreEqual("03FEB", result);
        }
        [NUnit.Framework.Test(Description = "Z")]
        public void AddDays()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime? result = CFW.Util.DateUtil.AddDays(d,30);

            Assert.IsNotNull(result);
            Assert.AreEqual(2001, result.Value.Year);
            Assert.AreEqual(3, result.Value.Month);
            Assert.AreEqual(5, result.Value.Day);
            Assert.AreEqual(12, result.Value.Hour);
            Assert.AreEqual(34, result.Value.Minute);
            Assert.AreEqual(56, result.Value.Second);
        }
        [NUnit.Framework.Test(Description = "Z")]
        public void AddMonths()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime? result = CFW.Util.DateUtil.AddMonths(d, 11);

            Assert.IsNotNull(result);
            Assert.AreEqual(2002, result.Value.Year);
            Assert.AreEqual(1, result.Value.Month);
            Assert.AreEqual(3, result.Value.Day);
            Assert.AreEqual(12, result.Value.Hour);
            Assert.AreEqual(34, result.Value.Minute);
            Assert.AreEqual(56, result.Value.Second);
        }
        [NUnit.Framework.Test(Description = "NZ")]
        public void AddYears()
        {
            DateTime d = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime? result = CFW.Util.DateUtil.AddYears(d, 11);

            Assert.IsNotNull(result);
            Assert.AreEqual(2012, result.Value.Year);
            Assert.AreEqual(2, result.Value.Month);
            Assert.AreEqual(3, result.Value.Day);
            Assert.AreEqual(12, result.Value.Hour);
            Assert.AreEqual(34, result.Value.Minute);
            Assert.AreEqual(56, result.Value.Second);
        }
        [NUnit.Framework.Test(Description = "")]
        public void DiffDays()
        {
            DateTime d1 = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime d2 = new DateTime(2001, 3, 4, 12, 34, 56);
            int days  = CFW.Util.DateUtil.DiffDays(d1, d2);

            Assert.AreEqual(29, days);
        }
        [NUnit.Framework.Test(Description = "")]
        public void MonthsAfter()
        {
            DateTime? d = CFW.Util.DateUtil.MonthAfter(2010,12,3) ;

            Assert.IsNotNull(d);
            Assert.AreEqual(2011, d.Value.Year);
            Assert.AreEqual(3, d.Value.Month);
        }
        [NUnit.Framework.Test(Description = "̌")]
        public void EndOfMonthAfter()
        {
            DateTime? d = CFW.Util.DateUtil.EndOfMonthAfter(2010, 12, 2);

            Assert.IsNotNull(d);
            Assert.AreEqual(2011, d.Value.Year);
            Assert.AreEqual(2, d.Value.Month);
            Assert.AreEqual(28, d.Value.Day);
        }
        [NUnit.Framework.Test(Description = "")]
        public void MonthNext()
        {
            DateTime? d = CFW.Util.DateUtil.NextMonth(2010, 12);

            Assert.IsNotNull(d);
            Assert.AreEqual(2011, d.Value.Year);
            Assert.AreEqual(1, d.Value.Month);
            Assert.AreEqual(1, d.Value.Day);
        }
        [NUnit.Framework.Test(Description = "O")]
        public void MonthPrevious()
        {
            DateTime? d = CFW.Util.DateUtil.PreviousMonth(2011, 1);

            Assert.IsNotNull(d);
            Assert.AreEqual(2010, d.Value.Year);
            Assert.AreEqual(12, d.Value.Month);
            Assert.AreEqual(1, d.Value.Day);
        }
        [NUnit.Framework.Test(Description = "")]
        public void EndOfMonth()
        {
            DateTime? d = CFW.Util.DateUtil.EndOfMonth(2004, 2);

            Assert.IsNotNull(d);
            Assert.AreEqual(2004, d.Value.Year);
            Assert.AreEqual(2, d.Value.Month);
            Assert.AreEqual(29, d.Value.Day);
        }
        [NUnit.Framework.Test(Description = "")]
        public void IsEndOfMonth()
        {
            bool result = CFW.Util.DateUtil.IsEndOfMonth(new DateTime(2004,2,29) );
            Assert.IsTrue(result);

            result = CFW.Util.DateUtil.IsEndOfMonth(new DateTime(2004, 3, 30));
            Assert.IsFalse(result);
        }
        [NUnit.Framework.Test(Description = "N")]
        public void AgeYear()
        {

            DateTime birthday = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2005, 3, 4, 12, 34, 56);
            int result = CFW.Util.DateUtil.AgeYear(birthday, baseDate);
            Assert.AreEqual(4,result);
        }
        [NUnit.Framework.Test(Description = "N ")]
        public void AgeYear2()
        {

            DateTime birthday = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2005, 2, 2, 12, 34, 56);
            int result = CFW.Util.DateUtil.AgeYear(birthday, baseDate);
            Assert.AreEqual(3, result);
        }
        [NUnit.Framework.Test(Description = "N() ")]
        public void AgeMonth()
        {

            DateTime birthday = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2002, 2, 2, 12, 34, 56);
            int result = CFW.Util.DateUtil.AgeMonth(birthday, baseDate);
            Assert.AreEqual(11, result);
        }
        [NUnit.Framework.Test(Description = "N() ")]
        public void AgeMonth2()
        {

            DateTime birthday = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2002, 2, 4, 12, 34, 56);
            int result = CFW.Util.DateUtil.AgeMonth(birthday, baseDate);
            Assert.AreEqual(12, result);
        }
        [NUnit.Framework.Test(Description = "N")]
        public void AgeString()
        {

            DateTime birthday = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2005, 3, 4, 12, 34, 56);
            string result = CFW.Util.DateUtil.AgeString(birthday, baseDate);
            Assert.AreEqual(" 4Y", result);
        }
        [NUnit.Framework.Test(Description = "N")]
        public void AgeString2()
        {

            DateTime birthday = new DateTime(1905, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2009, 3, 4, 12, 34, 56);
            string result = CFW.Util.DateUtil.AgeString(birthday, baseDate);
            Assert.AreEqual("104Y", result);
        }
        [NUnit.Framework.Test(Description = "N()")]
        public void AgeString3()
        {

            DateTime birthday = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2009, 3, 4, 12, 34, 56);
            string result = CFW.Util.DateUtil.AgeString(birthday, baseDate);
            Assert.AreEqual("13M", result);
        }
        [NUnit.Framework.Test(Description = "N")]
        public void AgeString4()
        {

            DateTime birthday = new DateTime(1965, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2009, 3, 4, 12, 34, 56);
            string result = CFW.Util.DateUtil.AgeString(birthday, baseDate);
            Assert.AreEqual("44Y", result);
        }
        [NUnit.Framework.Test(Description = "N")]
        public void AgeStringJP()
        {

            DateTime birthday = new DateTime(2001, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2005, 3, 4, 12, 34, 56);
            string result = CFW.Util.DateUtil.AgeStringJP(birthday, baseDate);
            Assert.AreEqual(" 4", result);
        }
        [NUnit.Framework.Test(Description = "N")]
        public void AgeStringJP2()
        {

            DateTime birthday = new DateTime(1905, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2009, 3, 4, 12, 34, 56);
            string result = CFW.Util.DateUtil.AgeStringJP(birthday, baseDate);
            Assert.AreEqual("104", result);
        }
        [NUnit.Framework.Test(Description = "N()")]
        public void AgeStringJP3()
        {

            DateTime birthday = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime baseDate = new DateTime(2009, 3, 4, 12, 34, 56);
            string result = CFW.Util.DateUtil.AgeStringJP(birthday, baseDate);
            Assert.AreEqual("13", result);
        }

        [NUnit.Framework.Test(Description = "͈̓`FbN")]
        public void IsInRange()
        {

            DateTime target = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime min = new DateTime(2008, 2, 2, 12, 34, 56);
            DateTime max = new DateTime(2008, 2, 4, 12, 34, 56);
            bool result = CFW.Util.DateUtil.IsInRange(target, min,max);
            Assert.IsTrue(result);
        }
        [NUnit.Framework.Test(Description = "͈̓`FbN")]
        public void IsInRange2()
        {

            DateTime target = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime min = new DateTime(2008, 2, 2, 12, 34, 56);
            DateTime max = new DateTime(2008, 2, 3, 0, 0, 0);
            bool result = CFW.Util.DateUtil.IsInRange(target, min, max);
            Assert.IsFalse(result);
        }
        [NUnit.Framework.Test(Description = "͈̓`FbN")]
        public void IsInRange3()
        {

            DateTime target = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime min = new DateTime(2008, 2, 2, 12, 34, 56);
            DateTime max = new DateTime(2008, 2, 3, 0, 0, 0);
            bool result = CFW.Util.DateUtil.IsInRange(target, min, null);
            Assert.IsTrue(result);
        }
        [NUnit.Framework.Test(Description = "͈̓`FbN")]
        public void IsInRange4()
        {

            DateTime target = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime min = new DateTime(2008, 2, 2, 12, 34, 56);
            DateTime max = new DateTime(2008, 2, 4, 0, 0, 0);
            bool result = CFW.Util.DateUtil.IsInRange(target, null,max);
            Assert.IsTrue(result);
        }
        [NUnit.Framework.Test(Description = "͈̓`FbN")]
        public void IsInRange5()
        {

            DateTime target = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime min = new DateTime(2008, 2, 2, 12, 34, 56);
            DateTime max = new DateTime(2008, 2, 4, 0, 0, 0);
            bool result = CFW.Util.DateUtil.IsInRange(target, null, null);
            Assert.IsFalse(result);
        }
        [NUnit.Framework.Test(Description = "͈̓`FbN")]
        public void IsInRange6()
        {

            DateTime target = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime min = new DateTime(2008, 2, 2, 12, 34, 56);
            DateTime max = new DateTime(2008, 2, 3, 0, 0, 0);
            bool result = CFW.Util.DateUtil.IsInRange(null, min, max);
            Assert.IsFalse(result);
        }
        [NUnit.Framework.Test(Description = "͈̓`FbN")]
        public void IsBetween()
        {

            DateTime target = new DateTime(2008, 2, 3, 12, 34, 56);
            DateTime min = new DateTime(2008, 2, 2, 12, 34, 56);
            DateTime max = new DateTime(2008, 2, 4, 12, 34, 56);
            bool result = CFW.Util.DateUtil.IsBetween(target, min, max);
            Assert.IsTrue(result);
        }
        [NUnit.Framework.Test(Description = "jCfbNX")]
        public void DayOfWeekIndex()
        {

            DateTime target = new DateTime(2009, 5, 20, 12, 34, 56);
            int result = CFW.Util.DateUtil.DayOfWeekIndex(target);
            Assert.AreEqual(3,result);

            result = CFW.Util.DateUtil.DayOfWeekIndex(null);
            Assert.AreEqual(-1, result);

            target = new DateTime(2009, 5, 17, 12, 34, 56);
            result = CFW.Util.DateUtil.DayOfWeekIndex(target);
            Assert.AreEqual(0, result);
        }

        [NUnit.Framework.Test(Description = "j")]
        public void DayOfWeekString()
        {

            DateTime target = new DateTime(2009, 5, 20, 12, 34, 56);
            string result = CFW.Util.DateUtil.DayOfWeekString(target);
            Assert.AreEqual("WED", result);

            result = CFW.Util.DateUtil.DayOfWeekString(null);
            Assert.AreEqual("", result);

            target = new DateTime(2009, 5, 17, 12, 34, 56);
            result = CFW.Util.DateUtil.DayOfWeekString(target);
            Assert.AreEqual("SUN", result);
        }
        [NUnit.Framework.Test(Description = "j")]
        public void DayOfWeekStringJP()
        {

            DateTime target = new DateTime(2009, 5, 20, 12, 34, 56);
            string result = CFW.Util.DateUtil.DayOfWeekStringJP(target);
            Assert.AreEqual("", result);

            result = CFW.Util.DateUtil.DayOfWeekStringJP(null);
            Assert.AreEqual("", result);

            target = new DateTime(2009, 5, 17, 12, 34, 56);
            result = CFW.Util.DateUtil.DayOfWeekStringJP(target);
            Assert.AreEqual("", result);
        }
        [NUnit.Framework.Test(Description = "MM/dd")]
        public void ParseMonthDay()
        {

            string d = "12/31";

            object result = CFW.Util.DateUtil.ParseMonthDay(d);
            Assert.IsInstanceOfType(typeof(DateTime),result);
            Assert.AreEqual(12, ((DateTime) result).Month);
            Assert.AreEqual(31, ((DateTime)result).Day);
            Assert.AreEqual(0, ((DateTime)result).Hour);
            Assert.AreEqual(0, ((DateTime)result).Minute);
            Assert.AreEqual(0, ((DateTime)result).Second);


        }
        [NUnit.Framework.Test(Description = "MMdd")]
        public void ParseMonthDay2()
        {

            string d = "1231";

            object result = CFW.Util.DateUtil.ParseMonthDay(d);
            Assert.IsInstanceOfType(typeof(DateTime), result);
            Assert.AreEqual(12, ((DateTime)result).Month);
            Assert.AreEqual(31, ((DateTime)result).Day);
            Assert.AreEqual(0, ((DateTime)result).Hour);
            Assert.AreEqual(0, ((DateTime)result).Minute);
            Assert.AreEqual(0, ((DateTime)result).Second);


        }
        [NUnit.Framework.Test(Description = "MM/ddo")]
        public void FormatMonthDay()
        {
            DateTime target = new DateTime(2009, 5, 17, 12, 34, 56);


            string result = CFW.Util.DateUtil.FormatMonthDay(target);
            Assert.AreEqual("05/17", result);

        }
        [NUnit.Framework.Test(Description = "MMddo")]
        public void FormatMonthDay2()
        {
            DateTime target = new DateTime(2009, 5, 17, 12, 34, 56);


            string result = CFW.Util.DateUtil.FormatMonthDayNoDelimiter(target);
            Assert.AreEqual("0517", result);

        }
        [NUnit.Framework.Test(Description = "t͉")]
        public void Parse()
        {
            string original = "2009/1/2 3:4:5.678";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(2009, result.Value.Year);
            Assert.AreEqual(1, result.Value.Month);
            Assert.AreEqual(2, result.Value.Day);
            Assert.AreEqual(3, result.Value.Hour);
            Assert.AreEqual(4, result.Value.Minute);
            Assert.AreEqual(5, result.Value.Second);
            Assert.AreEqual(678, result.Value.Millisecond);


        }
        [NUnit.Framework.Test(Description = "t͉ G[")]
        public void Parse2()
        {
            string original = "2009/2/29 3:4:5.678";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNull(result);

        }
        [NUnit.Framework.Test(Description = "t͉")]
        public void Parse3()
        {
            string original = "2009/12/31 23:59:59.999";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(2009, result.Value.Year);
            Assert.AreEqual(12, result.Value.Month);
            Assert.AreEqual(31, result.Value.Day);
            Assert.AreEqual(23, result.Value.Hour);
            Assert.AreEqual(59, result.Value.Minute);
            Assert.AreEqual(59, result.Value.Second);
            Assert.AreEqual(999, result.Value.Millisecond);
        }
        [NUnit.Framework.Test(Description = "}CNb")]
        public void Parse4()
        {
            string original = "2009/12/31 23:59:59.123456";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(2009, result.Value.Year);
            Assert.AreEqual(12, result.Value.Month);
            Assert.AreEqual(31, result.Value.Day);
            Assert.AreEqual(23, result.Value.Hour);
            Assert.AreEqual(59, result.Value.Minute);
            Assert.AreEqual(59, result.Value.Second);
            Assert.AreEqual(123, result.Value.Millisecond);
        }
        [NUnit.Framework.Test(Description = "؂Ȃt")]
        public void Parse5()
        {
            string original = "20101231";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(2010, result.Value.Year);
            Assert.AreEqual(12, result.Value.Month);
            Assert.AreEqual(31, result.Value.Day);
            Assert.AreEqual(0, result.Value.Hour);
            Assert.AreEqual(0, result.Value.Minute);
            Assert.AreEqual(0, result.Value.Second);
            Assert.AreEqual(0, result.Value.Millisecond);
        }
        [NUnit.Framework.Test(Description = "؂Ȃt")]
        public void Parse6()
        {
            string original = "101231";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(2010, result.Value.Year);
            Assert.AreEqual(12, result.Value.Month);
            Assert.AreEqual(31, result.Value.Day);
            Assert.AreEqual(0, result.Value.Hour);
            Assert.AreEqual(0, result.Value.Minute);
            Assert.AreEqual(0, result.Value.Second);
            Assert.AreEqual(0, result.Value.Millisecond);
        }
        [NUnit.Framework.Test(Description = "؂Ȃt")]
        public void Parse7()
        {
            DateTime now = DateTime.Now;
            string original = "101231";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(now.Year, result.Value.Year);
            Assert.AreEqual(12, result.Value.Month);
            Assert.AreEqual(31, result.Value.Day);
            Assert.AreEqual(0, result.Value.Hour);
            Assert.AreEqual(0, result.Value.Minute);
            Assert.AreEqual(0, result.Value.Second);
            Assert.AreEqual(0, result.Value.Millisecond);
        }
        [NUnit.Framework.Test(Description = "؂Ȃt")]
        public void Parse8()
        {
            DateTime now = DateTime.Now;
            string original = "1231";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(now.Year, result.Value.Year);
            Assert.AreEqual(12, result.Value.Month);
            Assert.AreEqual(31, result.Value.Day);
            Assert.AreEqual(0, result.Value.Hour);
            Assert.AreEqual(0, result.Value.Minute);
            Assert.AreEqual(0, result.Value.Second);
            Assert.AreEqual(0, result.Value.Millisecond);
        }

        [NUnit.Framework.Test(Description = "؂Ȃt")]
        public void Parse9()
        {
            DateTime now = DateTime.Now;
            string original = "528";

            DateTime? result = CFW.Util.DateUtil.Parse(original);

            Assert.IsNotNull(result);

            Assert.AreEqual(now.Year, result.Value.Year);
            Assert.AreEqual(5, result.Value.Month);
            Assert.AreEqual(28, result.Value.Day);
            Assert.AreEqual(0, result.Value.Hour);
            Assert.AreEqual(0, result.Value.Minute);
            Assert.AreEqual(0, result.Value.Second);
            Assert.AreEqual(0, result.Value.Millisecond);
        }

    }
}
