using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test
{
    [TestFixture]
    public class CryptTest
    {
        [NUnit.Framework.Test(Description = "ÍA")]
        public void Crypt()
        {
            string original = "7b832e3282944f3217e0e94091136e42";

            CFW.Util.Crypt crypt = new CFW.Util.Crypt();
            string crypted = crypt.EncryptStringEx(original, "open", "sesami");

            string decrypted = crypt.DecryptStringEx(crypted, "open", "sesami");

            Assert.AreEqual(original, decrypted);

        }
        [NUnit.Framework.Test(Description = "ÍA")]
        public void Crypt2()
        {
            string original = "7b832e3282944f3217e0e94091136e42";

            CFW.Util.Crypt crypt = new CFW.Util.Crypt();
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            string crypted = "";
            for (int i = 0; i < 1000; i++)
            {
                crypted = crypt.EncryptStringEx(original, "open", "sesami");
            }

            sw.Stop();

            CFW.Log.Logger logger = CFW.Log.LoggerFactory.GetLogger("default", "test");
            logger.Debug(System.Reflection.MethodBase.GetCurrentMethod().Name, "ellapsed=" + sw.ElapsedMilliseconds.ToString());

            string decrypted = crypt.DecryptStringEx(crypted, "open", "sesami");

            Assert.AreEqual(original, decrypted);

        }
    }
}
