using System;
using System.Collections.Generic;
using System.Configuration;
using System.Text;
using NUnit.Framework;

namespace CFW.Common.Test.Config
{
    [TestFixture]
    public class ConfigFileTest
    {
        [NUnit.Framework.Test(Description = "")]
        public void GetAppSettingString()
        {
            CFW.Config.ConfigFile appConfig = CFW.Config.ConfigFactory.GetConfig();
            string value = appConfig.GetAppSettingString("test");

            Assert.AreEqual("testetst", value);
        }
        [NUnit.Framework.Test(Description = "")]
        public void GetConfig()
        {
            CFW.Config.ConfigFile appConfig = CFW.Config.ConfigFactory.GetConfig("test.config");

            Assert.IsNotNull(appConfig);
            ConfigurationSection dataConfig = appConfig.GetSection("dataAccess");
            Assert.IsNotNull(dataConfig);
            Assert.IsInstanceOfType(typeof(CFW.Database.Config.ConnectionConfigSection),dataConfig);

        }

        [NUnit.Framework.Test(Description = "")]
        public void GetConfig2()
        {
            CFW.Config.ConfigFile appConfig = CFW.Config.ConfigFactory.GetConfig();

            Assert.IsNotNull(appConfig);
            ConfigurationSection dataConfig = appConfig.GetSection("dataAccess");
            Assert.IsNotNull(dataConfig);
            Assert.IsInstanceOfType(typeof(CFW.Database.Config.ConnectionConfigSection), dataConfig);

            int defaultCommandTimeout = ((CFW.Database.Config.ConnectionConfigSection)dataConfig).DefaultCommandTimeout;
            Assert.AreEqual(45, defaultCommandTimeout);

            CFW.Database.Config.ConnectionConfigElement el = ((CFW.Database.Config.ConnectionConfigSection)dataConfig).ConnectionConfigs["default"];
            Assert.AreEqual("CRAFT-DACSERVER", el.Url);

        }


    }
}
