using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace CFW.Auth.Test
{
    [TestFixture]
    public class DatabaseAuthProviderTest
    {
        [NUnit.Framework.Test(Description="ɃOC")]
        public void Authenticate()
        {
            CFW.Auth.AuthProvider provider = CFW.Auth.AuthProviderFactory.GetInstance();
            bool result = provider.Authenticate("m-okada", "okada");
            Assert.IsTrue(result);

            Assert.IsTrue(provider.IsAuthenticated());
            CFW.Auth.Identity identity = provider.GetIdentity();
            Assert.IsNotNull(identity);
            Assert.AreEqual("m-okada", identity.Name);
            Assert.AreEqual("m-okada", identity.User.Id);
            Assert.AreEqual("michiaki okada", identity.User.Name);



        }
        [NUnit.Framework.Test(Description = "ƓrŔF؂߂ApX[hԈႦꍇ")]
        public void Authenticate2()
        {
            CFW.Auth.AuthProvider provider = CFW.Auth.AuthProviderFactory.GetInstance();
            bool result = provider.Authenticate("m-okada", "okada");
            Assert.IsTrue(result);
            Assert.IsTrue(provider.IsAuthenticated());

            //ƓrŔF؂߂ApX[hԈႦꍇ
            result = provider.Authenticate("m-okada", "wrongpassword");
            //Authenticate͎s
            Assert.IsFalse(result);
            //F؏͕ωȂ
            Assert.IsTrue(provider.IsAuthenticated());
            CFW.Auth.Identity identity = provider.GetIdentity();
            Assert.IsNotNull(identity);



        }
        [NUnit.Framework.Test]
        public void LogOut()
        {
            CFW.Auth.AuthProvider provider = CFW.Auth.AuthProviderFactory.GetInstance();
            bool result = provider.Authenticate("m-okada", "okada");
            Assert.IsTrue(result);
            Assert.IsTrue(provider.IsAuthenticated());

            provider.Logout();

            Assert.IsFalse(provider.IsAuthenticated());
            CFW.Auth.Identity identity = provider.GetIdentity();
            Assert.IsNull(identity);



        }
        [NUnit.Framework.Test]
        public void WrongPassword()
        {
            CFW.Auth.AuthProvider provider = CFW.Auth.AuthProviderFactory.GetInstance();
            bool result = provider.Authenticate("m-okada", "wrongpassword");
            Assert.IsFalse(result);
            Assert.IsFalse(provider.IsAuthenticated());

        }
    }
}
