using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
namespace CFW.Acl.Test
{
    [TestFixture]
    public class DbAclTest
    {
        [NUnit.Framework.Test]
        public void IsAllowed()
        {
            CFW.Acl.AccessControl acl = CFW.Acl.AclFactory.GetInstance();
            CFW.Acl.IAclResource resource = acl.FindResourceByName("cfw");

            CFW.Auth.AuthProvider auth = CFW.Auth.AuthProviderFactory.GetInstance();
            bool result = auth.Authenticate("m-okada", "okada");
            Assert.IsTrue(result);

            CFW.Auth.Identity identity= auth.GetIdentity();

            List<CFW.Acl.IAclRole> roles = identity.Roles;

            //m-okada(common,logistics)
            result = acl.IsAllowed("cfw", AclPrivilege.All, roles);
            Assert.IsTrue(result);

            result = acl.IsAllowed("travelsys", AclPrivilege.All, roles);
            Assert.IsFalse(result);

            result = acl.IsAllowed("travelsys", AclPrivilege.Read, roles);
            Assert.IsTrue(result);

            result = acl.IsAllowed("ad", AclPrivilege.Read, roles);
            Assert.IsFalse(result);

            result = acl.IsAllowed("DAC", AclPrivilege.All, roles);
            Assert.IsTrue(result);

            result = acl.IsAllowed("kyoumukun", AclPrivilege.Read, roles);
            Assert.IsFalse(result);
            result = acl.IsAllowed("kyoumukun", AclPrivilege.Create, roles);
            Assert.IsFalse(result);
            result = acl.IsAllowed("kyoumukun", AclPrivilege.Update, roles);
            Assert.IsFalse(result);
            result = acl.IsAllowed("kyoumukun", AclPrivilege.Delete, roles);
            Assert.IsFalse(result);

        }
    }
}
