using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;
using System.Diagnostics;
using System.IO;
using CFW.Database;
using CFW.Log;
using CFW.Serializer;
using CFW.Util;
namespace WebSvc
{
    public partial class SerializeCheckForm : Form
    {
        Logger logger = LoggerFactory.GetLogger("default", "check");

        public SerializeCheckForm()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();
                SerializeTestBase test = new SerializeNormal();
                test.queryText = queryInput.Text;

                test.execute();
                sw.Stop();
                textBox1.AppendText(string.Format("normal execute end : {0:#,##0.000}ms", (double)sw.ElapsedTicks / (double)Stopwatch.Frequency));
                textBox1.AppendText(Environment.NewLine);
            }
            finally
            {
                logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            }            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();
                SerializeTestBase test = new SerializeSimple();
                test.queryText = queryInput.Text;
                test.execute();
                sw.Stop();
                textBox1.AppendText(string.Format("simple execute end : {0:#,##0.000}ms", (double)sw.ElapsedTicks / (double)Stopwatch.Frequency));
                textBox1.AppendText(Environment.NewLine);
            }
            finally
            {
                logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            }            

        }

        private void button3_Click(object sender, EventArgs e)
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();
                SerializeTestBase test = new SerializeJSON1();
                test.queryText = queryInput.Text;
                test.execute();
                sw.Stop();
                textBox1.AppendText(string.Format("json1 execute end : {0:#,##0.000}ms", (double)sw.ElapsedTicks / (double)Stopwatch.Frequency));
                textBox1.AppendText(Environment.NewLine);
            }
            finally
            {
                logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            }            

        }

        private void button4_Click(object sender, EventArgs e)
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            try
            {
                Stopwatch sw = new Stopwatch();
                sw.Start();
                SerializeTestBase test = new SerializeJSON2();
                test.queryText = queryInput.Text;
                test.execute();
                sw.Stop();
                textBox1.AppendText(string.Format("json2 execute end : {0:#,##0.000}ms", (double)sw.ElapsedTicks / (double)Stopwatch.Frequency));
                textBox1.AppendText(Environment.NewLine);
            }
            finally
            {
                logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            }            


        }
    }
    public class SerializeTestBase
    {
        private static Logger logger = LoggerFactory.GetLogger("default", MethodInfo.GetCurrentMethod().DeclaringType.Name);
        protected string serializedString;
        protected DataSet data;
        public string queryText = "";
        public void execute()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            try
            {
                data = getSampleData();
                if (data == null) return;
                Stopwatch sw = new Stopwatch();
                sw.Start();
                serialize();
                sw.Stop();
                logger.Debug(MethodInfo.GetCurrentMethod().Name,string.Format( "serialize : {0:#,##0.000}ms,size={1}",(double) sw.ElapsedTicks/ (double) Stopwatch.Frequency,StringUtil.LengthB(serializedString)));
                sw.Reset();
                sw.Start();
                desirialize();
                sw.Stop();
                logger.Debug(MethodInfo.GetCurrentMethod().Name, string.Format("deserialize : {0:#,##0.000}ms", (double)sw.ElapsedTicks / (double)Stopwatch.Frequency));
            }
            finally
            {
                logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            }
        }
        DataSet getSampleData()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            Connection con = ConnectionFactory.GetConnectionByName("default");

            try
            {
                con.Open();
                Command command = new Command(queryText);
                DataSet result = command.ExecuteQuery(con);
                return result;
            }
            catch (Exception ex)
            {
                logger.Debug(MethodInfo.GetCurrentMethod().Name, "exception " + ex.ToString());
                return null;
            }
            finally
            {
                con.Close();
                logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            }
        }
        protected virtual void serialize()
        {
        }
        protected virtual void desirialize()
        {
        }
    }
    public class SerializeNormal : SerializeTestBase
    {
        private static Logger logger = LoggerFactory.GetLogger("default", MethodInfo.GetCurrentMethod().DeclaringType.Name);
        protected override void serialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            XmlSerializer serializer = new XmlSerializer(typeof(DataSet));
            StringWriter writer = new StringWriter();
            serializer.Serialize(writer, data);
            serializedString = writer.ToString();
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
        }
        protected override void desirialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            XmlSerializer serializer = new XmlSerializer(typeof(DataSet));
            StringReader writer = new StringReader(serializedString);
            data = (DataSet) serializer.Deserialize(writer);
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
        }
    }
    public class SerializeSimple : SerializeTestBase
    {
        private static Logger logger = LoggerFactory.GetLogger("default", MethodInfo.GetCurrentMethod().DeclaringType.Name);
        protected override void serialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            DataSXSerializer serializer = new DataSXSerializer();
            StringWriter writer = new StringWriter();
            serializer.SerializeDataSet(writer, data);
            serializedString = writer.ToString();
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            writer.Close();
        }
        protected override void desirialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            DataSXSerializer serializer = new DataSXSerializer();
            StringReader reader = new StringReader(serializedString);
            data = (DataSet)serializer.DeserializeDataSet(reader);
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            reader.Close();
        }
    }
    public class SerializeJSON1 : SerializeTestBase
    {
        private static Logger logger = LoggerFactory.GetLogger("default", MethodInfo.GetCurrentMethod().DeclaringType.Name);
        protected override void serialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            DataSetJSON serializer = new DataSetJSON();
            StringWriter writer = new StringWriter();
            serializer.SerializeDataSet(writer, data);
            serializedString = writer.ToString();
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            writer.Close();
        }
        protected override void desirialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            DataSetJSON serializer = new DataSetJSON();
            StringReader reader = new StringReader(serializedString);
            data = (DataSet)serializer.DeserializeDataSet(reader);
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
            reader.Close();
        }
    }
    public class SerializeJSON2 : SerializeTestBase
    {
        private static Logger logger = LoggerFactory.GetLogger("default", MethodInfo.GetCurrentMethod().DeclaringType.Name);
        protected override void serialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            DataSetJSON2 serializer = new DataSetJSON2();
            StringWriter writer = new StringWriter();
            serializer.SerializeDataSet(writer, data);
            serializedString = writer.ToString();
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
        }
        protected override void desirialize()
        {
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "start");
            DataSetJSON2 serializer = new DataSetJSON2();
            StringReader writer = new StringReader(serializedString);
            data = (DataSet)serializer.DeserializeDataSet(writer);
            logger.Debug(MethodInfo.GetCurrentMethod().Name, "end");
        }
    }
}