using System;
using System.Collections.Generic;
using System.Text;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.IO;
using System.Data;
using CFW.Util;

namespace WebSvc
{
    public class DataSetJSON2
    {
        JavaScriptObject jso;

        /// <summary>
        /// dataset VACY
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="data"></param>
        public void SerializeDataSet(TextWriter writer, DataSet data)
        {


            jso = createDataSetElement(data);
            JsonSerializer serializer = new JsonSerializer();
            serializer.Serialize(writer, jso);

        }
        /// <summary>
        /// xmlDataTableɂŃVACY
        /// </summary>
        /// <param name="reader"></param>
        /// <returns></returns>
        public DataSet DeserializeDataSet(TextReader reader)
        {
            JsonSerializer serializer = new JsonSerializer();
            JsonReader jreader = new JsonReader(reader);
            JavaScriptObject jso = (JavaScriptObject)serializer.Deserialize(jreader);
           
            return parseDataSet(jso);

        }

        #region create
        JavaScriptObject createDataSetElement(DataSet data)
        {
            JavaScriptObject element = new JavaScriptObject();
            JavaScriptArray arr = new JavaScriptArray();
            foreach (DataTable table in data.Tables)
            {
                arr.Add(createDataTableElement(table));
            }
            element.Add("tables", arr);
            return element;
        }
        JavaScriptObject createDataTableElement(DataTable table)
        {
            JavaScriptObject element = new JavaScriptObject();
            element.Add("name", table.TableName);
            element.Add("columns", createColumnsElement(table));
            element.Add("rows", createDataRowsElement(table));

            return element;
        }
        JavaScriptArray createColumnsElement(DataTable table)
        {
            JavaScriptArray arr = new JavaScriptArray();

            for (int i = 0; i < table.Columns.Count; i++)
            {
                JavaScriptObject columnElement = new JavaScriptObject();

                DataColumn column = table.Columns[i];
                columnElement.Add("name", column.ColumnName);
                columnElement.Add("type", column.DataType.FullName);
                columnElement.Add("nullable", column.AllowDBNull); 
                arr.Add(columnElement);

            }
            return arr;
        }

        JavaScriptArray createDataRowsElement(DataTable table)
        {
            JavaScriptArray arr = new JavaScriptArray();

            for (int i = 0; i < table.Rows.Count; i++)
            {
                JavaScriptObject rowElement = createDataRowElement(table.Rows[i]);
                arr.Add(rowElement);
            }
            return arr;

        }
        JavaScriptObject createDataRowElement(DataRow row)
        {
            JavaScriptObject rowElement = new JavaScriptObject();

            for (int i = 0; i < row.Table.Columns.Count; i++)
            {
                DataColumn column = row.Table.Columns[i];
                object o = row[column];
                if (o is DateTime) o = o.ToString();

                if (o == DBNull.Value) rowElement.Add(column.ColumnName,null);
                else rowElement.Add(column.ColumnName, o);
            }
            return rowElement;
        }

        #endregion
        #region parse
        DataSet parseDataSet(JavaScriptObject element)
        {
            DataSet s = new DataSet();
            JavaScriptArray tables = (JavaScriptArray)element["tables"];
            for (int i = 0; i < tables.Count; i++)
            {
                DataTable t = parseTable((JavaScriptObject)tables[i]);
                s.Tables.Add(t);
            }
            return s;

        }
        DataTable parseTable(JavaScriptObject element)
        {
            DataTable t = new DataTable();
            t.TableName = (string)element["name"];

            JavaScriptArray columnsElement = (JavaScriptArray)element["columns"];
            t.Columns.AddRange(parseColumns(columnsElement));

            JavaScriptArray rowsElement = (JavaScriptArray)element["rows"];
            for (int i = 0; i < rowsElement.Count; i++)
            {
                JavaScriptObject rowElement = (JavaScriptObject)rowsElement[i];
                DataRow row = t.NewRow();
                for (int c = 0; c < columnsElement.Count; c++)
                {
                    string columnName = StringUtil.StringValue(((JavaScriptObject)columnsElement[c])["name"]);
                    if (rowElement.ContainsKey(columnName))
                    {
                        if (rowElement[columnName] == null) row[columnName] = DBNull.Value;
                        else row[columnName] = rowElement[columnName];
                    }
                }
                t.Rows.Add(row);
            }
            return t;

        }

        DataColumn[] parseColumns(JavaScriptArray element)
        {
            DataColumn[] columns = new DataColumn[element.Count];
            for (int i = 0; i < element.Count; i++)
            {
                DataColumn col = parseColumn((JavaScriptObject)element[i]);
                columns[i] = col;
            }
            return columns;
        }
        DataColumn parseColumn(JavaScriptObject element)
        {
            string columnName = (string)element["name"];
            string typeName = (string)element["type"];
            bool allowDbNUll = NumberUtil.BoolValue(element["nullable"]);

            DataColumn col = new DataColumn(columnName, Type.GetType(typeName));
            col.AllowDBNull = allowDbNUll;
            return col;
        }
        #endregion

        #region util
        object fixValue(DataColumn c, object val)
        {
            Type objectType = c.DataType;
            if (val == null) return null;

            if (objectType == typeof(int))
            {
                return NumberUtil.Value<Int32>(val);
            }
            if (objectType == typeof(byte))
            {
                return NumberUtil.Value<Byte>(val);
            }
            if (objectType == typeof(short))
            {
                return NumberUtil.Value<Int16>(val);
            }
            if (objectType == typeof(long))
            {
                return NumberUtil.Value<Int64>(val);
            }
            if (objectType == typeof(bool))
            {
                return NumberUtil.Value<bool>(val);
            }
            if (objectType == typeof(DateTime))
            {
                return DateUtil.DateValue(val);
            }
            if (objectType == typeof(decimal))
            {
                return NumberUtil.Value<decimal>(val);
            }
            if (objectType == typeof(float))
            {
                return NumberUtil.Value<float>(val);
            }
            if (objectType == typeof(double))
            {
                return NumberUtil.Value<double>(val);
            }
            if (objectType == typeof(Type))
            {
                return Type.GetType(val.ToString());
            }
            if (objectType.IsEnum)
            {
                return val;
            }
            if (objectType.IsPrimitive || objectType.IsValueType)
            {
                return val;
            }

            return val;
        }
        #endregion
    }
}
